/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp.qt

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.model.stext.stext.StatechartScope

class QtExtensions {
	
	@Inject protected extension GeneratorPredicate
	
	def requiresEventFlag(Event it) {
		(useOutEventGetters && direction == Direction.OUT) 
		|| direction != Direction.OUT
	}
	
	
	/** TODO : this should not be here */
	def requiresInitializer(Declaration it) {
		if (it instanceof Event) {
			requiresEventFlag
		}
		else true
	}
	
	def hasCodeDeclarations(StatechartScope scope) {
		! scope.declarations
				.filter[ d | if (d instanceof Event) d.requiresEventFlag else true ]
				.isEmpty
	}
	
}