/**
* Copyright (c) 2018-2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Axel Terfloth - itemis AG
*
*/
package com.yakindu.sct.generator.cpp.qt

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.files.TimerServiceSource
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class QtTimerServiceImplementation extends TimerServiceSource {

	@Inject extension QtNaming
	@Inject extension GenmodelEntries
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#include "«(timerServiceModule.h).relativeTo(timerServiceModule.cpp)»"
		
				
		using namespace sc::qt;
		
		
		SCTimer::SCTimer(QObject *parent, «weakPtr»sc::timer::TimedInterface«pointerType» machine, const sc::eventid id) :
		    machine(machine),
		    eventId(id)
		{
		    connect(this, SIGNAL(timeout()), this, SLOT(triggerTimeEvent()));
		}
		
		void SCTimer::triggerTimeEvent()
		{
		    emit fireTimeEvent(machine.lock(), eventId);
		}
		
		SCTimer::~SCTimer()
		{
		}
		
		SCTimerService::SCTimerService(QObject *parent)
		{
		}
		
		SCTimerService::~SCTimerService() 
		{
		}
		
		void SCTimerService::setTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» statemachine, sc::eventid event, «sc_time.fqName» time_ms, bool isPeriodic)
		{
		    «sharedPtr»SCTimer«pointerType» timer = nullptr;
		
		    // retrieve the timer map for the state machine
		    QMap<sc::eventid, «sharedPtr»SCTimer«pointerType»> *eventTimerMap = machineTimerMapMap.value(statemachine);
		
		    // retrieve and stop a timer if it already exists for the event.
		    if (eventTimerMap != nullptr) {
		
		        if (eventTimerMap->contains(event)) {
		           «sharedPtr»SCTimer«pointerType» timer = eventTimerMap->value(event);
		           timer->stop();
		        }
		    }
		
		    //setup the event timer map for the state machine if it not alrewady exists
		    if ( eventTimerMap == nullptr) {
		        eventTimerMap = new QMap<sc::eventid, «sharedPtr»SCTimer«pointerType»>();
		        machineTimerMapMap.insert(statemachine, eventTimerMap);
		    }
		
		    // create a timer if it not already exists
		    if (timer == nullptr) {
		        timer = «makeSharedPtr»SCTimer«pointerType»(this, statemachine, event);
		        eventTimerMap->insert(event, timer);
		        timer->connect(timer.get(), SIGNAL(fireTimeEvent(«sharedPtr»sc::timer::TimedInterface«pointerType»,sc::eventid)), this, SLOT(raiseTimeEvent(«sharedPtr»sc::timer::TimedInterface«pointerType»,sc::eventid)));
		    }
		
		    // amor the timer
		    timer->setTimerType(Qt::TimerType::PreciseTimer);
		    timer->setInterval(time_ms);
		    timer->setSingleShot(!isPeriodic);
		    timer->start();
		
		}
		
		
		«sharedPtr»SCTimer«pointerType» SCTimerService::getTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» machine, sc::eventid event)
		{
		    «sharedPtr»SCTimer«pointerType» timer = nullptr;
		
		    // retrieve the timer map for the state machine
		    QMap<sc::eventid, «sharedPtr»SCTimer«pointerType»> *eventTimerMap = machineTimerMapMap.value(machine);
		
		    // retrieve and a timer registered for the event.
		    if (eventTimerMap != nullptr) {
		
		        if (eventTimerMap->contains(event)) {
		            timer = eventTimerMap->value(event);
		        }
		    }
		
		    return timer;
		}
		
		
		void SCTimerService::unsetTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» statemachine, sc::eventid event)
		{
		    «sharedPtr»SCTimer«pointerType» timer = this->getTimer(statemachine, event);
		
		    if (timer != nullptr) {
		        timer->stop();
		    }
		
		    // do nothing else as the timer may be reused...
		}
		
		
		void SCTimerService::raiseTimeEvent(«sharedPtr»sc::timer::TimedInterface«pointerType» machine, sc::eventid event)
		{
		    «sharedPtr»SCTimer«pointerType» timer = this->getTimer(machine, event);
		    if (timer != nullptr && timer->isSingleShot()) {
		        timer->stop();
		    }
		
		    if (machine != nullptr) {
		        machine->raiseTimeEvent(event);
		    }
		}
		
		
		void SCTimerService::cancel()
		{
		}
		

	'''
	
}