/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.genmodel.ui

import com.google.inject.Binder
import com.google.inject.Provider
import com.google.inject.name.Names
import org.eclipse.ui.plugin.AbstractUIPlugin
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider
import org.eclipse.xtext.resource.containers.IAllContainersState
import org.eclipse.xtext.ui.editor.contentassist.ITemplateProposalProvider
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover
import org.eclipse.xtext.ui.editor.hover.IEObjectHover
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory
import org.eclipse.xtext.ui.editor.model.JavaClassPathResourceForIEditorInputFactory
import org.eclipse.xtext.ui.editor.model.ResourceForIEditorInputFactory
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator
import org.eclipse.xtext.ui.resource.IResourceSetProvider
import org.eclipse.xtext.ui.resource.SimpleResourceSetProvider
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider
import org.eclipse.xtext.ui.shared.Access
import com.yakindu.base.utils.jface.help.CrossRefObjectTextHover
import com.yakindu.base.utils.jface.help.HelpHoverProvider
import com.yakindu.base.utils.jface.help.HelpHoverProvider.OpenInHelpAction
import com.yakindu.sct.generator.core.filesystem.ISCTWorkspaceAccess
import com.yakindu.sct.generator.genmodel.ui.help.SGenUserHelpDocumentationProvider
import com.yakindu.sct.generator.genmodel.ui.highlighting.SGenHighlightingConfiguration
import com.yakindu.sct.generator.genmodel.ui.highlighting.SGenSemanticHighlightingCalculator
import com.yakindu.sct.generator.genmodel.ui.templates.SGenTemplateProposalProvider
import com.yakindu.sct.generator.genmodel.ui.ws.DefaultSCTWorkspaceAccess

class SGenUiModule extends AbstractSGenUiModule {
	new(AbstractUIPlugin plugin) {
		super(plugin)
	}

	def configureHelpAction(Binder binder) {
		binder.bind(typeof(String)).annotatedWith(Names.named(OpenInHelpAction.CONTEXTID)).toInstance(
			"com.yakindu.sct.ui.editor.sgen_feature")
	}

	def Class<? extends ISemanticHighlightingCalculator> bindISemanticHighlightingCalculator() {
		SGenSemanticHighlightingCalculator
	}

	def Class<? extends IHighlightingConfiguration> bindIHighlightingConfiguration() {
		SGenHighlightingConfiguration
	}

	def Class<? extends IEObjectDocumentationProvider> bindIEObjectDocumentationProvider() {
		SGenUserHelpDocumentationProvider
	}

	def Class<? extends DispatchingEObjectTextHover> bindDispatchingEObjectTextHover() {
		CrossRefObjectTextHover
	}

	def Class<? extends IEObjectHoverProvider> bindIEObjectHoverProvider() {
		HelpHoverProvider
	}

	override Class<? extends IEObjectHover> bindIEObjectHover() {
		CrossRefObjectTextHover
	}

	override Class<? extends ITemplateProposalProvider> bindITemplateProposalProvider() {
		SGenTemplateProposalProvider
	}

	override Provider<IAllContainersState> provideIAllContainersState() {
		return Access.getWorkspaceProjectsState()
	}

	override Class<? extends IResourceSetProvider> bindIResourceSetProvider() {
		return if (Access.getJdtHelper().get().isJavaCoreAvailable()) {
			XtextResourceSetProvider
		} else {
			SimpleResourceSetProvider
		}
	}

	override Class<? extends IResourceForEditorInputFactory> bindIResourceForEditorInputFactory() {
		return if (Access.getJdtHelper().get().isJavaCoreAvailable()) {
			JavaClassPathResourceForIEditorInputFactory
		} else {
			ResourceForIEditorInputFactory
		}
	}

	def Class<? extends ISCTWorkspaceAccess> bindISCTWorkspaceAccess() {
		DefaultSCTWorkspaceAccess
	}
}
