/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.yakindu.base.expressions.interpreter.context.DefaultExecutionSlotInitialValueProvider
import com.yakindu.base.expressions.interpreter.context.PropertyInitialValueAdapter.LazyInitialValue
import com.google.common.cache.LoadingCache
import java.util.Optional
import com.google.common.cache.CacheBuilder
import com.google.common.cache.CacheLoader
import com.yakindu.sct.domain.c.runtime.resource.IMacroDefinitionParser
import com.google.inject.Inject

/**
 * Provides initial values for execution slots and evaluates C/C++ macro definitions.
 * 
 * @author Axel Terfloth 
 */
class CDomainExecutionSlotInitialValueProvider extends DefaultExecutionSlotInitialValueProvider {
	
	static val MAX_CACHE_SIZE = 10000;


	@Inject IMacroDefinitionParser parser

	val LoadingCache<String, Optional<Object>> macroCache = CacheBuilder.newBuilder().maximumSize(MAX_CACHE_SIZE).build(
		new CacheLoader<String, Optional<Object>>() {
			override Optional<Object> load(String key) {
				val value = parser.parseMacroDefinition(key)?.value
				if(value !== null) Optional.of(value) else Optional.empty
			}
		});
	
	override value(Object it) {
		getValue
	}

	def dispatch getValue(Object it) {
		it
	}

	def dispatch getValue(LazyInitialValue lazyValue) {
		val result = macroCache.get(lazyValue.expression)
		if(result.isPresent) result.get else null
	}
	
}