/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Laszlo Kovacs - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.typesystem.ITypeSystem
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId

import static com.yakindu.sct.generator.c.typesystem.CTypeSystem.*

class Cpp11StdTypeMapper extends C99StdTypeMapper {

	@Inject extension ITypeSystem
	protected extension TypesFactory factory = TypesFactory.eINSTANCE

	override map(IASTNamedTypeSpecifier it) {
		if (name.lastName instanceof ICPPASTTemplateId) {
			val template = name.lastName as ICPPASTTemplateId
			return switch (it) {
				case template.templateName.toString.equals("unique_ptr"): getType(UNIQUE_POINTER).addArguments(template).type
				case template.templateName.toString.equals("weak_ptr"): getType(WEAK_POINTER).addArguments(template).type
				case template.templateName.toString.equals("shared_ptr"): getType(SHARED_POINTER).addArguments(template).type
				default: super.map(it)
			}
		} else {
			super.map(it)
		}
	}
	
	override mapTypeSpecifier(IASTNamedTypeSpecifier it) {
		if (name.lastName instanceof ICPPASTTemplateId) {
			val template = name.lastName as ICPPASTTemplateId
			return switch (it) {
				case template.templateName.toString.equals("unique_ptr"): getType(UNIQUE_POINTER).addArguments(template)
				case template.templateName.toString.equals("weak_ptr"): getType(WEAK_POINTER).addArguments(template)
				case template.templateName.toString.equals("shared_ptr"): getType(SHARED_POINTER).addArguments(template)
				default: super.mapTypeSpecifier(it)
			}
		} else {
			super.mapTypeSpecifier(it)
		}
	}

	def addArguments(Type it, ICPPASTTemplateId template) {
		createTypeSpecifier => [ts |
			ts.type = it
			template.templateArguments.filter(ICPPASTTypeId).forEach[ ta | 
				ts.typeArguments += createTypeSpecifier => [
					type = getType((ta.declSpecifier as IASTNamedTypeSpecifier).name.toString)
					//type = ta.declSpecifier.findOrCreateType
			]]
		]
	}
}
