/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform

import java.util.List
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNode
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition

/**
 * @author rbeckmann
 *
 */
class PackageHierarchy {
	protected List<String> segments
	
	new(IASTDeclSpecifier declSpecifier) {
		segments = newArrayList
		
		buildPath(declSpecifier.parent)
	}
	
	def void buildPath(IASTNode node) {
		if(node.parent !== null) {
			buildPath(node.parent)
		}
		var name = ""
		if(node instanceof ICPPASTNamespaceDefinition) {
			name = node.name.toString
		}
		if(node instanceof ICPPASTCompositeTypeSpecifier) {
			name = node.name.toString 
		}
		
		if(name != "") {
			segments += name
		}
	}
	
	def getSegments() {
		return segments;
	}
}