/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.c

import com.yakindu.sct.domain.c.runtime.resource.NameToIdConverter
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import org.eclipse.cdt.core.dom.ast.IASTDeclarator
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNameOwner
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNode
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification

/**
 * @author rbeckmann
 * 
 */
class CTypeNaming {
	
	/**
	 * Suffix for types that do not have an own name but still need to be transformed, hence they get the name of one 
	 * of the enclosing declaration's declarators appended by this suffix (e.g. unnamed structs within typedefs)
	 */
	public static final String ANONYMOUS_TYPE_SUFFIX = "$0";
	/**
	 * Fall-back name used for elements without a name (e.g. unnamed structs with no enclosing typedef)
	 */
	public static final String ANONYMOUS_NAME = "";
	
	public static final String FQN_SEP = "$";

	protected extension NameToIdConverter converter = new NameToIdConverter

	def protected dispatch needsAnonymousName(IASTEnumerationSpecifier specifier) {
		specifier.getName().toString.empty
	}
	def protected dispatch needsAnonymousName(IASTCompositeTypeSpecifier specifier) {
		specifier.getName().toString.empty
	}
	def protected dispatch needsAnonymousName(IASTNode specifier) {
		false
	}
	def protected dispatch needsAnonymousName(IASTNameOwner specifier) {
		false
	}

	def protected dispatch String anonymousName(IASTSimpleDeclaration declaration) {
		val declarator = declaration.declarators.head
		if (declarator !== null) {
			val parentDecl = declaration.parent
			if (parentDecl.contributesToAnonymousName) {
				val parentName = parentDecl.name
				if (!parentName.empty) {
					return parentName + FQN_SEP + declarator.name.toString + ANONYMOUS_TYPE_SUFFIX
				}
			}
			return declarator.name.toString + ANONYMOUS_TYPE_SUFFIX
		} else {
			return ANONYMOUS_NAME
		}
	}
	
	def dispatch protected boolean contributesToAnonymousName(IASTNode specifier) {
		true;
	}
	
	def dispatch protected  contributesToAnonymousName(ICPPASTLinkageSpecification specifier) {
		false // if C project uses Cpp files CDT is parsing the ifdef extern "C" linkage specification
	}
	
	def dispatch String anonymousName(IASTNode node) {
		ANONYMOUS_NAME
	}
	
	def dispatch name(IASTTranslationUnit specifier) {
		""
	}
	
	def dispatch name(IASTNode it) {
		""
	}

	def dispatch name(IASTNamedTypeSpecifier specifier) {
		return specifier.getName().toString
	}

	def dispatch name(IASTElaboratedTypeSpecifier specifier) {
		return specifier.getName().toString
	}
	
	def dispatch name(IASTDeclarator declarator) {
		declarator.name.toString
	}
	
	def dispatch name(IASTNameOwner specifier) {
		System.err.println("No name could be computed for " + specifier)
		null
	}

	def dispatch name(IASTDeclSpecifier specifier) {
		specifier.needsAnonymousName ? specifier.parent.anonymousName : specifier.ASTName.toString
	}
	
	def dispatch getASTName(IASTNamedTypeSpecifier specifier) {
		return specifier.getName()
	}

	def dispatch getASTName(IASTElaboratedTypeSpecifier specifier) {
		return specifier.getName()
	}

	def dispatch getASTName(IASTEnumerationSpecifier specifier) {
		return specifier.getName()
	}

	def dispatch getASTName(IASTCompositeTypeSpecifier specifier) {
		return specifier.getName()
	}
	
	def dispatch getASTName(IASTDeclarator decl) {
		return decl.getName
	}

	def dispatch getASTName(IASTNameOwner specifier) {
		System.err.println("No name could be computed for " + specifier)
		null
	}
	
	def dispatch getASTName(IASTDeclSpecifier specifier) {
		System.err.println("No name could be computed for " + specifier)
		null
	}
	
	def dispatch String qualifiedName(IASTNode specifier) {
		name(specifier)
	}
	
	def dispatch String qualifiedName(IASTNameOwner specifier) {
		name(specifier)
	}
	
	def isBuiltInType(String name){ false }
	
}
