/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.c

import org.eclipse.emf.ecore.resource.Resource

class UnresolvableTypeProblem implements Resource.Diagnostic {

	static String UNRESOLVED_TYPE = "Could not resolve type ";

	String message;

	new(String type) {
		this.message = type.message
	}
	
	def static getMessage(String type) {
		return UNRESOLVED_TYPE + type
	}

	override String getMessage() {
		return message;
	}

	override String getLocation() {
		return "";
	}

	override int getLine() {
		return 0;
	}

	override int getColumn() {
		return 0;
	}
}
