/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.cpp

import com.google.inject.Inject
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeNaming
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNameOwner
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNode
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding
import org.eclipse.cdt.core.dom.ast.IBinding
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.SM_INTERFACE
import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.SM_CYCLEBASED_INTERFACE
import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.SM_EVENTDRIVEN_INTERFACE

/**
 * @author rbeckmann
 *
 */
class CPPTypeNaming extends CTypeNaming {
	
	@Inject extension CPPTypeUtils
	
	def dispatch name(ICPPASTBaseSpecifier specifier) {
		new String(specifier.nameSpecifier.toCharArray)
	}
	
	override dispatch name(IASTNamedTypeSpecifier specifier) {
		return specifier.getASTName.toString
	}

	def dispatch getASTName(ICPPASTBaseSpecifier specifier) {
		specifier.getName()
	}
	
	def dispatch getASTName(ICPPASTSimpleTypeTemplateParameter param) {
		param.getName()
	}
	
	override dispatch getASTName(IASTNamedTypeSpecifier specifier) {
		val name = specifier.getName()
		if (name instanceof ICPPASTTemplateId) {
			return name.templateName
		}
		return name
	}
	
	override protected boolean contributesToAnonymousName(IASTNode specifier) {
		if (specifier instanceof IASTCompositeTypeSpecifier) {
			// classes produce an own package, so we do not need to qualify their members' names
			return !specifier.isClass
		}
		if (specifier instanceof ICPPASTNamespaceDefinition)
			return false;
		return true
	}
	
	def dispatch String qualifiedName(IBinding binding) {
		binding.getName()
	}
	
	def dispatch String qualifiedName(ICPPBinding binding) {
		binding.getQualifiedName().join(FQN_SEP)
	}
	
	override dispatch String qualifiedName(IASTNode specifier) {
		val qn = specifier.ASTName.resolveBinding.qualifiedName
		specifier.needsAnonymousName ? qn + name(specifier) : qn
	}

	override dispatch String qualifiedName(IASTNameOwner specifier) {
		val qn = specifier.ASTName.resolveBinding.qualifiedName
		specifier.needsAnonymousName ? qn + name(specifier) : qn
	}
	
	override isBuiltInType(String name){
		if(SM_INTERFACE.equals(name) || SM_CYCLEBASED_INTERFACE.equals(name) || SM_EVENTDRIVEN_INTERFACE.equals(name))
			true
		else
			false
	}
	
}