/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.types

import com.google.inject.Inject
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource
import com.yakindu.sct.domain.c.runtime.resource.transform.TypeScope
import java.util.List
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import com.yakindu.base.types.Type

/**
 * @author rbeckmann
 * 
 */
class CTypeHandlerChain {
	@Inject protected BuiltInTypeHandler builtInTypeHandler
	@Inject protected ProxyTypeHandler proxyTypeHandler
	@Inject protected TypeScopeHandler typeScopeHandler
	@Inject protected TypeCreationHandler creationHandler
	@Inject protected UnsupportedTypeHandler unsupportedTypeHandler

	protected TypeHandler next;

	protected List<TypeHandler> handlers

	def void setup(TypeScope scope, CHeaderResource resource) {
		next = builtInTypeHandler
		builtInTypeHandler.next = proxyTypeHandler
		proxyTypeHandler.next = typeScopeHandler
		typeScopeHandler.next = creationHandler
		creationHandler.next = unsupportedTypeHandler

		handlers = #[
			builtInTypeHandler,
			proxyTypeHandler,
			typeScopeHandler,
			creationHandler,
			unsupportedTypeHandler
		]

		handlers.filter(ITypeScopeOwner).forEach[it.typeScope = scope]
		val resourceOwners = handlers.filter(IResourceOwner)
		resourceOwners.forEach[it.resource = resource]
	}

	def Type findType(IASTDeclSpecifier declSpecifier) {
		next.find(declSpecifier)
	}

}
