/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.types

import com.google.inject.Inject
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource
import com.yakindu.sct.domain.c.runtime.resource.transform.ProxyBuilder
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNameOwner
import org.eclipse.xtend.lib.annotations.Accessors

/**
 * @author rbeckmann
 *
 */
class ProxyTypeHandler extends TypeHandler implements IResourceOwner {
	@Inject protected extension ProxyBuilder
	@Accessors(PUBLIC_SETTER) protected extension CHeaderResource resource
	
	override protected handle(IASTDeclSpecifier declSpecifier) {
		if (declSpecifier instanceof IASTNameOwner) {
			val declFileLocation = declSpecifier.pathToDeclaringHeader
			if (!resourceLocation.equals(declFileLocation)) {
				// create proxy for external declarations
				return createTypeProxy(resource, declFileLocation.toString, declSpecifier)
			}
		}
		return null
	}
	
}