/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.validator

import com.google.inject.Inject
import com.google.inject.name.Named
import java.util.HashMap
import java.util.Map
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.Direction
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod

/**
 * @author rbeckmann
 * 
 */
class StatechartIdentifiers {
	@Inject protected extension SExecExtensions

	@Inject protected extension Naming

	@Inject protected extension INamingService namingService

	@Inject @Named("Separator") protected String separator
	
	@Inject protected extension RunCycleMethod

	def Map<NamedElement, String> getIdentifiers(ExecutionFlow it) {
		namingService.initializeNamingService(it)

		val map = newHashMap

		putAPIFunctions(map)
		putScopeContents(map)
		putIfaceStructs(map)

		map
	}
	
	def void add(Map<NamedElement, String> map, NamedElement key, String data) {
		val s = map.put(key, data)
		if(s !== null) {
			if(s.length > data.length) {
				map.put(key, s)
			}
		}
	}
	
	def putIfaceStructs(ExecutionFlow it, HashMap<NamedElement, String> map) {
		for (scope : scopes.filter(InterfaceScope)) {
			map.add(scope, scope.type)
		}
		for (scope : scopes.filter(InternalScope)) {
			map.add(it, scope.type)
		}
	}

	def putScopeContents(ExecutionFlow it, HashMap<NamedElement, String> map) {
		for (scope : scopes) {
			for (decl : scope.declarations) {
				switch (decl) {
						TimeEvent: {
							map.add(decl, timeEventRaisedFlag(decl))
						}
						VariableDefinition: {
							map.add(decl, variable(decl))
							map.add(decl, asGetter(decl).toString)
							if(!decl.const && !decl.readonly) 
								map.add(decl, asSetter(decl))
						}
						EventDefinition: {
							if(decl.type !== null && decl.type.name != 'void')
								map.add(decl, eventValueVariable(decl))
							map.add(decl, eventRaisedFlag(decl))
							if(decl.direction == Direction::IN) {
								map.add(decl, asRaiser(decl))
							} else {
								map.add(decl, asRaised(decl))
								if(decl.hasValue) {
									map.add(decl, asGetter(decl).toString)
								}
							}
						}
				}
			}
		}
	}
	
	def String eventVariables(EventDefinition it) {
		var flag = eventRaisedFlag
		var value = if(type !== null && type.name != 'void') {
			eventValueVariable
		} else {""}
		
		if(flag.length > value.length) flag
		else value
	}

	def putVariableFunctions(ExecutionFlow it, HashMap<NamedElement, String> map) {
	}

	def putIFaceGetters(ExecutionFlow it, HashMap<NamedElement, String> map) {
	}

	def putAPIFunctions(ExecutionFlow it, Map<NamedElement, String> map) {
		if(timed) map.put(it, raiseTimeEventFctID)
		map.put(it, isStateActiveFctID)
		map.put(it, isActiveFctID)
		map.put(it, isFinalFctID)
		map.put(it, initFctID)
		map.put(it, enterFctID)
		map.put(it, exitFctID)
		if (hasRunCycleFunctionAsAPI) map.put(it, runCycleFctID)
	}
}
