/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sgraph.util

import com.yakindu.sct.model.sgraph.Entry
import com.yakindu.sct.model.sgraph.EntryKind
import com.yakindu.sct.model.sgraph.FinalState
import com.yakindu.sct.model.sgraph.Pseudostate
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.SGraphFactory
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Transition
import java.util.ArrayList
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

class SgraphExtensions {
	
	def factory() { SGraphFactory::eINSTANCE }
	
	def dispatch isLeaf(RegularState s) { false }
	
	def dispatch isLeaf(FinalState s) {true}
	
	def dispatch isLeaf(State s) { s.simple }

	// TODO: rename since this list also includes the start state or change implementation and usages
	def List<RegularState> parentStates(RegularState s) {
		s.containers.filter( typeof(RegularState) ).toList		
	}

	def List<RegularState> parentStates(Region s) {
		s.containers.filter( typeof(RegularState) ).toList		
	}


	def parentState (EObject obj) {
		EcoreUtil2.getAllContainers(obj).filter(typeof (RegularState)).head
	} 

	
	def List<EObject> containers(EObject obj) {
		val containerList = new ArrayList<EObject>()
		collectContainers(obj, containerList)
		return containerList
	}
	
	def void collectContainers(EObject obj, List<EObject> containerList) {
		containerList += obj
		if (obj?.eContainer !== null) collectContainers(obj.eContainer, containerList);
	}

	def collectEntries(Region r) {
		r.vertices.filter(typeof(Entry))
	}

	def entry(Region r) {
		r.vertices.findFirst(v | v instanceof Entry && (v.name === null || "".equals(v.name) || v.name == 'default') ) as Entry
	}

	/**
	 * Retrieves the target from an entry.
	 * TODO: validation of preconditions for entry targets e.g every region needs an entry with appropriate target
	 */
	def State target(Entry entry) {
		val obj = entry.transition?.target
		if (obj instanceof State ) return obj		
		
		return null
	}
	
	def Transition transition(Entry entry) {
		if ( entry?.outgoingTransitions !== null) {
			if (entry.outgoingTransitions.size > 0) {
				return entry.outgoingTransitions.get(0)
			}
		}	
		
		return null	
	}
		
	
	def Iterable<RegularState> allStates(EObject it) {
		it.allStates([true])	
	}
	
	def dispatch Iterable<RegularState> allStates(EObject it, (RegularState)=>boolean condition) {
		#[]	
	}
	
	
	def dispatch Iterable<RegularState> allStates(Statechart it, (RegularState)=>boolean condition) {
		regions
			.map[allStates(condition)]
			.flatten	
	}
	
	def dispatch Iterable<RegularState> allStates(Region it, (RegularState)=>boolean condition) {
		vertices
			.filter(RegularState)
			.map[allStates(condition)]
			.flatten
	}
	
	def dispatch Iterable<RegularState> allStates(RegularState it, (RegularState)=>boolean condition) {
		if (condition === null || condition.apply(it)) 
			return #[it]
	}
	
	def dispatch Iterable<RegularState> allStates(State it, (RegularState)=>boolean condition) {
		val List<RegularState> states = new ArrayList
		
		if (condition === null || condition.apply(it)) states += it
			
		states +=
		(regions
			.map[allStates(condition)]
			.flatten)
			
		states
	}
	
	def dispatch Iterable<Pseudostate> getAllPseudoStates(State it) {
		regions.map[allPseudoStates].flatten
	}

	def dispatch Iterable<Pseudostate> getAllPseudoStates(Region it) {
		vertices.filter(Pseudostate)
	}

	def dispatch Iterable<Pseudostate> getAllPseudoStates(List<?> it) {
		map[allPseudoStates].flatten
	}

	def dispatch Iterable<Pseudostate> getAllPseudoStates(EObject it) {
		#[]
	}
	
	def dispatch Iterable<Pseudostate> getAllPseudoStates(Object it) {
		#[]
	}

	def dispatch Iterable<Pseudostate> getAllPseudoStates(Void it) {
		#[]
	}	
	
	def getRegionsWithoutDefaultEntry(List<Region> it) {
		return newHashMap(
			it.filter(r | r.eContents.filter(Entry).filter(e | e.isDefault).empty).map[r | r -> r.eContents.filter(Entry).filter(Entry).toList]
		)
	}
	
	def requireDeepHistory(Region r) {
		 r.containers.filter(typeof(Region)).exists(p|p.vertices.filter(typeof(Entry)).exists(v|v.kind == EntryKind::DEEP_HISTORY))
	}
	def requireShallowHistory(Region r) {
		r.vertices.filter(typeof(Entry)).exists(v|v.kind == EntryKind::SHALLOW_HISTORY)		
	}
	def requireHistory(Region r) {
		r.requireDeepHistory || r.requireShallowHistory
	}
	
	def Statechart getStatechart(EObject element){
		if(element === null) {
			return null
		}
		EcoreUtil2.getContainerOfType(element, typeof(Statechart))
	}
	
	/** 
	 * Returns whether interleaved or non-interleaved execution order for local reactions is required.
	 * 
	 * Local reactions are interleaved when they are processed directly after a states transition checks. 
	 * They are not interleaved if they are processed after all transitions along the state hierarchy are checked.
	 * 
	 * Currently just interleaved execution order is supported for all kinds of statecharts. Especially orthogonal 
	 * statecharts are not supported with non interleaved execution order. That's why just true is returned. In future
	 * an annotation should be introduced.
	 * 
	 * @return true if interleaved local reaction execution is required.
	 */
	def boolean interleaveLocalReactions(Statechart it) {
		return true	
	}
}