/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.python.extensions

import com.google.inject.Inject
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import org.eclipse.emf.ecore.EObject

class CallbackExtensions {

	@Inject extension NamingExtensions
	@Inject extension Naming

	def dispatch CharSequence setCallBack(Scope it) {
	}

	/**Sets the OperationCallback */
	def dispatch CharSequence setCallBack(InternalScope it) {
		'''
			«operationCallBack» «mockObjectName»;
		'''
	}

	/**Sets the OperationCallback */
	def dispatch CharSequence setCallBack(InterfaceScope it) {
		'''
			«operationCallBack» «mockObjectName»;
		'''
	}

	/**Sets the Mock of the InternalInterface as the InternalOperationCallback of the Statemachine*/
	def dispatch CharSequence setOperationCallback(InternalScope it) {
		'''
			self.«statemachineReferenceName».«operationCallBack» = mock.Mock()
			«FOR op : members.filter(OperationDefinition)»
			self.«statemachineReferenceName».«operationCallBack».«op.identifier» = mock.Mock(side_effect=default_«getMockOperationName(op)»)
			«ENDFOR»
		'''
	}

	/**Sets the Mock of the Interface as the InterfaceOperationCallback of the Statemachine*/
	def dispatch CharSequence setOperationCallback(InterfaceScope it) {
		'''
			self.«statemachineReferenceName».«operationCallBack» = mock.Mock()
			«FOR op : members.filter(OperationDefinition)»
			self.«statemachineReferenceName».«operationCallBack».«op.identifier» = mock.Mock(side_effect=default_«getMockOperationName(op)»)
			«ENDFOR»
		'''
	}

	def dispatch getMockOperationName(InternalScope it, OperationDefinition op) {
		return '''«op.identifier»'''
	}
	
	def dispatch getMockOperationName(InterfaceScope it, OperationDefinition op) {
		return '''sci_«IF name === null»interface«ELSE»«name»«ENDIF»_«op.identifier»'''
	}
	
	def dispatch getMockOperationName(EObject it, OperationDefinition op) {
		'''#Cannot find scope '«it»' for '«op»'.'''
	}
		
	/**Unsets OperationCallback of the Statemachine*/
	def dispatch CharSequence unsetOperationCallback(Scope it) {
		if (it instanceof InterfaceScope) {
			it.unsetOperationCallback
		} else {
			(it as InternalScope).unsetOperationCallback
		}
	}

	/**Unsets OperationCallback of the Statemachine*/
	def dispatch CharSequence unsetOperationCallback(InterfaceScope it) {
		'''
			self.«statemachineReferenceName».«operationCallBack» = None
		'''
	}

	/**Unsets OperationCallback of the Statemachine*/
	def dispatch CharSequence unsetOperationCallback(InternalScope it) {
		'''
			self.«statemachineReferenceName».internalOperationCallback = None
		'''
	}

}