/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*	Jonathan Thoene - itemis AG
* 
*/

package com.yakindu.sctunit.generator.python.extensions

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Type
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.generator.python.naming.PythonNamingService
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import org.eclipse.emf.ecore.EObject

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author jonathan thoene - Adding of functions to generate mocking statements
 * TODO: Merge with NamingExtensions from Interpreter generator
 */
 

class NamingExtensions extends BaseNamingExtensions{

	@Inject extension Naming
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension OriginTracing
	@Inject extension PythonNamingService
	
	def statemachineClassName(SCTUnitClass it) {
		statechartName.asIdentifier
	}
	
	def statemachineReferenceName(){
		"statemachine"
	}
	
	def statechartName(SCTUnitClass it){
		return statechart.name.statemachineName
	}
	
	override testClassName(SCTUnitElement it) {
		name.toFirstUpper
	}
		
	def testClassClassName(SCTUnitElement it) {
		name.toLowerCase.toFirstUpper
	}	
	
	override operationName(SCTUnitOperation it) {
		name.asIdentifier
	}
	
	def dispatch CharSequence operationCallBack(Scope it){}
	
	def dispatch CharSequence operationCallBack(InterfaceScope it) {
		if (!name.nullOrEmpty) {
			'''«interfaceVariableName».«operationCallbackInstance»'''
		} else {
			'''«operationCallbackInstance»'''
		}
	}
	
	def dispatch CharSequence operationCallBack(InternalScope it){
		'''«operationCallbackInstance»'''
	}
	
	def argumentCapture(Type type){
		'''«type.targetLanguageName.toFirstLower»Capture'''	
	}
	
	def methodName(SCTUnitOperation it){
		'''«operationName»'''
	}
	
	override dispatch valueSetter(VariableDefinition it) {
		return '''self.statemachine.«valueAccess»'''
	}
	
	override dispatch valueSetter(FeatureCall it) {
		feature.valueAccess
	}
	
	// TODO: Reuse from SExecExtensions
	def sexec_scope(EObject it) {
		var container = eContainer
		if (container instanceof ComplexType){
			val origin = it.originTraces.head
			if(origin instanceof Declaration){
				container = origin.eContainer
			}
		}
		if (container instanceof Scope) container
		else null
	}
	
	def dispatch valueAccess(NamedElement it) {
		val scope = sexec_scope
		if (scope instanceof InterfaceScope)
			'''«IF !scope.name.nullOrEmpty»«scope.interfaceVariableName».«ENDIF»«identifier»'''
		else
			'''«identifier»'''
	}
	
	def eventRaisingAccess(NamedElement it) {
		val scope = sexec_scope
		if (scope instanceof InterfaceScope)
			'''«IF !scope.name.nullOrEmpty»«scope.interfaceVariableName».«ENDIF»raise_«identifier»'''
		else
			'''«identifier»'''
	}
	
	def dispatch valueAccess(EObject it) {
		'''
		""""
		Can not valueAcces '«it.getClass.name»'
		""""
		'''
	}
	
	def dispatch getterName(EventDefinition definition) {
		'''«definition.identifier»'''
	}
	
	def dispatch getterName(VariableDefinition definition) {
		return definition.identifier
	}
	
	def dispatch getterName(EObject eObject) {
		'''#unknown getter name for «eObject»'''
	}
	
}