/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.generator.python.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Property
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.ExpressionStatement
import com.yakindu.sctunit.sCTUnit.IfStatement
import com.yakindu.sctunit.sCTUnit.LoopStatement
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.ReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author jonathan thoene - Adding of templates to generate mocking statements
 * 
 */
class PythonStatementExtensions extends BaseStatementExtensions {

	@Inject extension PythonExpressionExtensions
	@Inject extension UnittestMockingExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension Naming
	@Inject extension StatechartAnnotations

	override dispatch CharSequence generate(ExpressionStatement stm) {
		if ((stm.expression instanceof PrimitiveValueExpression) && stm.contextNotAssignOrVarDef) {
			return '''return «stm.expression.code»'''
		} 
		return '''«stm.expression.code»'''
	}

	def dispatch CharSequence generate(AssertionStatement stm) {
		'''
			self.assertTrue(«stm.expression.code»«IF !stm.errorMsg.nullOrEmpty», '«stm.errorMsg»'«ENDIF»)
		'''
	}
	
	override dispatch CharSequence generate(IfStatement stm) {
		stm.code
	}

	override dispatch CharSequence generate(VariableDefinitionStatement stm) {
		if (stm.definition.initialValue !== null) {
			'''«stm.definition.identifier» = «stm.definition.initialValue.code»'''
		} else {
			'''«stm.definition.identifier» = None'''
		}
	}

	override dispatch CharSequence generate(LoopStatement stm) {
		'''	
			while («stm.guard.code»):
				«IF stm.body.code.nullOrEmpty»
				pass
				«ENDIF»
				«FOR statement : stm.body.code»
					«statement.generate»
				«ENDFOR»
		'''
	}
	
	override dispatch CharSequence generate(ReturnStatement stm) {
		'''return «IF stm.returnValue !== null»«stm.returnValue.code»«ENDIF»'''
	}

	def dispatch CharSequence generate(VerifyCalledStatement it) {
		generateVerify
	}

	def dispatch CharSequence generate(MockReturnStatement it) {
		generateMockReturn
	}
	
	override generateInitialValue(VariableDefinition it, Expression expr) { 
		'''	
			«type.targetLanguageName» = «expr.code»
		'''
	}

	def getCyclePeriod(SCTUnitClass it) {
		it.statechart.cyclePeriod
	}
	
	def protected isTypeString(Property it) {
		it.typeSystem.isSame(getType?.originType, it.typeSystem.getType(ITypeSystem.STRING))
	}
}