/**
 * Copyright (c) 2017 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.python.extensions

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.ArrayList
import java.util.Collections
import java.util.HashMap
import java.util.LinkedList
import java.util.List
import java.util.Map

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
 @Singleton
class UnittestMockingExtensions extends BaseMockingExtensions {

	@Inject extension NamingExtensions
	@Inject extension SCTUnitPythonExpressionExtensions
	@Inject extension CallbackExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension ITypeSystem
	@Inject extension Naming
	
	var List<Operation> mockedOperations;
	
	def clearMockedOperations() {
		if(!mockedOperations.nullOrEmpty) {
			mockedOperations.clear()
		}
	}
	
	def String mockingImports(SCTUnitClass it, GeneratorEntry entry) {
		'''
			from unittest import mock
		'''
	}

	def defaultMock(Scope scope){
	'''
		«FOR operation : scope.members.filter(OperationDefinition).toList»
			#pylint: disable=unused-argument
			def default_«scope.getMockOperationName(operation)»(*args, **kwargs):
				«operation.type.returnDefaultValue»
		«ENDFOR»
	'''
	}
	
	def returnDefaultValue(Type it) {
		if(isSame(getType(ITypeSystem.BOOLEAN))){
			return '''return False'''
		} else if (isSame(getType(ITypeSystem.INTEGER))){
			return '''return 0'''
		} else if (isSame(getType(ITypeSystem.REAL))){
			return '''return 0.0'''
		} else if (isSame(getType(ITypeSystem.STRING))){
			return "return ''"
		}
		return '''pass'''
	}
	
	def dispatch String mockOperationCallbacks(Scope it) {
		// Should never be called
	}

	def dispatch String mockOperationCallbacks(InterfaceScope it) {
		'''
			«setOperationCallback»
		'''
	}

	def dispatch String mockOperationCallbacks(InternalScope it) {
		'''
			«setOperationCallback»
		'''
	}

	def protected argumentCaptureInit(Type type, String name, int index,
		VerifyCalledStatement ve) {
		'''ArgumentCaptor<«type.targetLanguageName.toFirstUpper»> «type.argumentCapture»«name»_«ve.statementIndex»_«index» = forClass(«type.targetLanguageName.toFirstUpper».class);'''
	}

	def String generateVerify(VerifyCalledStatement it) {
		'''
			self.«IF negated»assertFalse«ELSE»assertTrue«ENDIF»(«callCount» >=«(times ?: intLiteral(1)).code»)
		'''
	}
	
	def callCount(VerifyCalledStatement it) {
		var scope = reference.operation.scope
		val operation = '''self.«statemachineReferenceName».«scope.operationCallBack».«operationName»'''
		if(reference.expressions.nullOrEmpty) {
			return '''«operation».call_count'''
		} else {
			return '''len([call for call in «operation».call_args_list if call == call(«FOR arg : reference.expressions SEPARATOR ", "»«arg.code»«ENDFOR»)])'''
		}
	}
	
	def dispatch getExpressions(ArgumentExpression reference) {
		reference.expressions
	}
	
	def dispatch getExpressions(Expression reference) {
		null
	}
	

	protected def CharSequence getCaptureName(Parameter param, VerifyCalledStatement ve) {
		'''«param.type.argumentCapture»«ve.operationName»_«ve.statementIndex»_«ve.reference.operation.parameters.indexOf(param)»'''
	}

	protected def String getOperationName(VerifyCalledStatement ve) {
		ve.reference.getOperation.identifier
	}

	protected def getStatementIndex(TestStatement stmt) {
		(stmt.eContainer.eGet(stmt.eContainingFeature) as List<TestStatement>).indexOf(stmt)
	}

	def String generateMockReturn(MockReturnStatement stm)	'''
			«IF !isAlreadyMocked(stm)»
				self.«statemachineReferenceName».«stm.reference.operation.scope.operationCallBack».«stm.reference.getOperation.identifier» = mock.Mock(side_effect=«stm.reference.operation.identifier»_side_effect)
			«ENDIF»
		'''
	
	protected def boolean isAlreadyMocked(MockReturnStatement stm){
		if (mockedOperations === null) {
			mockedOperations = new ArrayList<Operation>()
		}
		for (op : mockedOperations){
			if(stm.reference.operation.hashCode == op.hashCode){
				return true
			}
		}
		mockedOperations.add(stm.reference.operation)
		return false
	} 
	
	
	/**
	 * Generate a map of all mocked operations and their parameters.
	 *  
	 */
	def Map<Operation, LinkedList<MockReturnStatement>> generateSideEffectList(SCTUnitOperation it) {
		if(!mockedOperations.nullOrEmpty){
			mockedOperations.clear()
		}
		var HashMap<Operation, LinkedList<MockReturnStatement>> map = new HashMap<Operation, LinkedList<MockReturnStatement>>()
		var found = false
		for(TestStatement s : body.code){
			if(s instanceof MockReturnStatement){
				if(map.empty){
					map.addNewLinkedListToMap(s)
				} else {
					/* try to find a fitting key */
					for (k : map.keySet()){
						if (k.hashCode == s.reference.operation.hashCode){
							found = true
							if(s instanceof MockReturnStatement && (s as MockReturnStatement).getOperationParameters.empty){
								map.get(k).addLast((s as MockReturnStatement))
							} else {
								map.get(k).addFirst((s as MockReturnStatement))
							}
							// TODO: break loop
						}	
					}
					/* if no key found, add element */
					if(found == false){
						map.addNewLinkedListToMap(s)
					} else {
						found = false
					}
				}
			}
		}
		return map
	}
	
	private def addNewLinkedListToMap(HashMap<Operation, LinkedList<MockReturnStatement>> map, MockReturnStatement s){
		var LinkedList<MockReturnStatement> l = new LinkedList<MockReturnStatement>()
		l.add((s))
		map.put(s.reference.operation, l)
	}
	
	/**
	 * Generates side effect functions for mocks.
	 */
	def CharSequence generateSideEffects(Map<Operation, LinkedList<MockReturnStatement>> map)
	{
	'''
		«IF map !== null || map.empty»
			«FOR entry : map.entrySet()»
				#pylint: disable=unused-argument
				def «entry.key.identifier»_side_effect(*args, **kwargs):
					«IF !entry.value.nullOrEmpty»
						«FOR mrs : entry.value»
							«IF !mrs.reference.argumentExpressions.nullOrEmpty»
								if args[0] == («FOR Parameter p : mrs.operationParameters»«mrs.reference.argumentExpressions.get(mrs.operationParameters.indexOf(p)).code»«ENDFOR»):
									return «mrs.value.code»
							«ENDIF»
						«ENDFOR»
						«FOR mrs : entry.value»
							«IF mrs.reference.argumentExpressions.nullOrEmpty»
								return «mrs.value.code»
							«ENDIF»
						«ENDFOR»
					«ELSE»
						return 
					«ENDIF»
					
			«ENDFOR»
		«ENDIF»
	'''
	}
	
	protected def List<Parameter> getOperationParameters (MockReturnStatement it){
		reference.getOperation.parameters
	}
	
	override dispatch List<Expression> argumentExpressions(Expression it){}
	
	override dispatch List<Expression> argumentExpressions(ElementReferenceExpression it){
		if(expressions.nullOrEmpty){
			return Collections.emptyList
		}else {
			return expressions
		}
	}
	
	override dispatch List<Expression> argumentExpressions(FeatureCall it){
		if(expressions.nullOrEmpty){
			return Collections.emptyList
		}else {
			return expressions
		}
	}
}