/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class ExitValidator
extends AbstractSGraphValidator {
    private static final String EXIT_TRANSITIONS_MUST_HAVE_N_IN_MSG = "Exit node should have at least one incoming transition.";
    public static final String EXIT_TRANSITIONS_MUST_HAVE_N_IN_CODE = "exit.transitions.MustHaveNIn";
    private static final String EXIT_TRANSITIONS_NO_OUT_MSG = "Exit node must not have outgoing transitions.";
    public static final String EXIT_TRANSITIONS_NO_OUT_CODE = "exit.transitions.NoOut";

    @Check(value=CheckType.FAST)
    public void checkExitTransitionsMustHaveNIn(Exit exit) {
        if (exit.getIncomingTransitions().size() == 0) {
            this.error(EXIT_TRANSITIONS_MUST_HAVE_N_IN_MSG, (EObject)exit, null, -1, EXIT_TRANSITIONS_MUST_HAVE_N_IN_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkExtitTransitionsNoOut(Exit exit) {
        if (exit.getOutgoingTransitions().size() > 0) {
            this.error(EXIT_TRANSITIONS_NO_OUT_MSG, (EObject)exit, null, -1, EXIT_TRANSITIONS_NO_OUT_CODE, new String[0]);
        }
    }
}

