/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs.actions;

import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.AbstractInvalidLicenseAction;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;

public class BuyLicenseAction
extends AbstractInvalidLicenseAction {
    private static final String BUY_LICENSE_MESSAGE = "Buy a license at the website.";
    private static final String EXTEND_MAINTANANCE_MESSAGE = "Extend maintenance for your license.";
    private final String featureId;
    private final boolean extendMaintanance;

    public BuyLicenseAction(String featureId, boolean extendMaintanance) {
        this.featureId = featureId;
        this.extendMaintanance = extendMaintanance;
    }

    public BuyLicenseAction(String featureId) {
        this(featureId, false);
    }

    @Override
    public Image getImage() {
        return LicenseManagementUiActivator.getDefault().getImage("icons/buy.png");
    }

    @Override
    public String getActionText() {
        return this.extendMaintanance ? EXTEND_MAINTANANCE_MESSAGE : BUY_LICENSE_MESSAGE;
    }

    @Override
    public StyleRange getStyleRange() {
        return this.createStyleRange(0, this.extendMaintanance ? 18 : 3);
    }

    @Override
    public void run(Composite parent) {
        Program.launch((String)EclipseLicenseHelper.INSTANCE.getFeatureUrl(this.featureId));
    }
}

