/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences.providers;

import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class NotificationLabelProvider
extends ColumnLabelProvider {
    private static final Image IMG_NOTIFICATION_ENABLED = LicenseManagementUiActivator.getDefault().getImage("icons/bell_enabled_small.png");
    private static final Image IMG_NOTIFICATION_DISABLED = LicenseManagementUiActivator.getDefault().getImage("icons/bell_disabled_small.png");
    private final Map<String, Boolean> notifications;

    public NotificationLabelProvider(Map<String, Boolean> notifications) {
        this.notifications = notifications;
    }

    public String getText(Object element) {
        TableItemData elem = (TableItemData)element;
        switch (this.getNotificationStatus(elem)) {
            case ENABLED: {
                return " (on)";
            }
            case DISABLED: {
                return " (off)";
            }
        }
        return "";
    }

    public Image getImage(Object element) {
        TableItemData elem = (TableItemData)element;
        switch (this.getNotificationStatus(elem)) {
            case ENABLED: {
                return IMG_NOTIFICATION_ENABLED;
            }
            case DISABLED: {
                return IMG_NOTIFICATION_DISABLED;
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        TableItemData elem = (TableItemData)element;
        switch (this.getNotificationStatus(elem)) {
            case ENABLED: {
                return "Disable notifications for this license";
            }
            case DISABLED: {
                return "Enable notifications for this license";
            }
        }
        return "";
    }

    private NotificationStatus getNotificationStatus(TableItemData elem) {
        boolean isUsed;
        NotificationStatus ret = null;
        AbstractLicenseFeature licenseFeature = elem.getLicenseFeature();
        String licenseFeatureId = licenseFeature.getLicenseFeatureId();
        boolean bl = isUsed = licenseFeature != null;
        ret = isUsed && this.notifications.containsKey(licenseFeatureId) ? (this.notifications.get(licenseFeatureId).booleanValue() ? NotificationStatus.ENABLED : NotificationStatus.DISABLED) : NotificationStatus.UNSETTABLE;
        return ret;
    }

    private static enum NotificationStatus {
        ENABLED,
        DISABLED,
        UNSETTABLE;

    }
}

