/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.image.features;

import com.google.common.collect.ImmutableSet;
import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;

public class ImageLibraryDefaultFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    public static final ImmutableSet<String> VALID_FORMATS = ImmutableSet.of((Object)"png", (Object)"jpg", (Object)"jpeg", (Object)"bmp", (Object)"svg");

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return "Image Generator".equals(library.getName());
    }

    public IStatus validateParameterValue(FeatureParameterValue parameterValue) {
        String parameterName = parameterValue.getParameter().getName();
        if ("format".equals(parameterName) && !VALID_FORMATS.contains((Object)parameterValue.getStringValue().toLowerCase())) {
            return this.error("Unknown format. Valid formats are " + VALID_FORMATS.toString());
        }
        return super.validateParameterValue(parameterValue);
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        String parameterName = parameterValue.getParameter().getName();
        if ("targetFolder".equals(parameterName)) {
            parameterValue.setValue("images");
        } else if ("targetProject".equals(parameterName)) {
            parameterValue.setValue(this.getProjectName(contextElement));
        } else if ("format".equals(parameterName)) {
            parameterValue.setValue("png");
        }
    }
}

