/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.inferrer;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.GenericElement;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.base.types.validation.TypeValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeParameterInferrer {
    @Inject
    private ITypeSystem registry;
    @Inject
    private TypeValidator typeValidator;
    @Inject
    @Extension
    private ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    @Extension
    protected OriginTracing _originTracing;

    public void inferTypeParametersFromOperationArguments(List<TypedDeclaration> parameters, List<ITypeSystemInferrer.InferenceResult> arguments, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        int _size_1;
        boolean _lessEqualsThan;
        int _size = parameters.size();
        boolean bl = _lessEqualsThan = _size <= (_size_1 = arguments.size());
        if (_lessEqualsThan) {
            int i = 0;
            while (i < parameters.size()) {
                TypeSpecifier parameter = parameters.get(i).getTypeSpecifier();
                ITypeSystemInferrer.InferenceResult argument = arguments.get(i);
                boolean _parameterContainsTypeParameter = this.parameterContainsTypeParameter(parameter);
                if (_parameterContainsTypeParameter) {
                    IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
                    IValidationIssueAcceptor _function = it -> {
                        thisIssueAcceptor.accept(it);
                        acceptor.accept(it);
                    };
                    this.assertArgumentAndParameterSoftCompatible(argument, parameter, _function);
                    boolean _isEmpty = thisIssueAcceptor.getTraces().isEmpty();
                    if (_isEmpty) {
                        this.inferTypeParameterFromOperationArgument(parameter, argument, inferredTypeParameterTypes, acceptor);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean parameterContainsTypeParameter(TypeSpecifier specifier) {
        Type type;
        Type _type = null;
        if (specifier != null) {
            _type = specifier.getType();
        }
        if ((type = _type) instanceof PrimitiveType) {
            return false;
        }
        if (type instanceof TypeParameter) {
            return true;
        }
        if (type instanceof ComplexType) {
            boolean _tripleNotEquals;
            EList _typeParameters = ((ComplexType)type).getTypeParameters();
            boolean bl = _tripleNotEquals = _typeParameters != null;
            if (_tripleNotEquals) {
                return true;
            }
            Iterable _filter = Iterables.filter((Iterable)((ComplexType)type).getFeatures(), Property.class);
            for (Property prop : _filter) {
                boolean _parameterContainsTypeParameter = this.parameterContainsTypeParameter(prop.getTypeSpecifier());
                if (!_parameterContainsTypeParameter) continue;
                return true;
            }
        }
        return false;
    }

    protected void inferTypeParameterFromOperationArgument(TypeSpecifier parameterTypeSpecifier, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        Type parameterType;
        Type _type = null;
        if (parameterTypeSpecifier != null) {
            _type = parameterTypeSpecifier.getType();
        }
        if ((parameterType = _type) instanceof TypeParameter) {
            this.doInferTypeParameterFromOperationArgument((TypeParameter)parameterType, argumentType, inferredTypeParameterTypes, acceptor);
        } else if (parameterType instanceof GenericElement) {
            boolean _isAnyType = this.typeValidator.isAnyType(argumentType.getType());
            if (_isAnyType) {
                return;
            }
            this.doInferGenericTypeFromOperationArgument(parameterTypeSpecifier, argumentType, inferredTypeParameterTypes, acceptor);
        }
    }

    protected void doInferGenericTypeFromOperationArgument(TypeSpecifier parameterTypeSpecifier, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        int i = 0;
        while (i < parameterTypeSpecifier.getTypeArguments().size()) {
            boolean _lessEqualsThan;
            TypeSpecifier typeParameter = (TypeSpecifier)parameterTypeSpecifier.getTypeArguments().get(i);
            Functions.Function1 _function = it -> {
                String _name = it.getType().getName();
                return Objects.equals(_name, "__statechart_type__");
            };
            boolean _exists = IterableExtensions.exists((Iterable)argumentType.getType().getAnnotations(), (Functions.Function1)_function);
            if (_exists) {
                this.typeValidator.assertCompatible(ITypeSystemInferrer.InferenceResult.from((Type)typeParameter.getType()), (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)argumentType.getBindings()), String.format("Incompatible types %s and %s.", argumentType, ITypeSystemInferrer.InferenceResult.from((Type)typeParameter.getType(), (List)argumentType.getBindings())), acceptor);
                return;
            }
            int _size = argumentType.getBindings().size();
            boolean bl = _lessEqualsThan = _size <= i;
            if (_lessEqualsThan) {
                this.error(acceptor, typeParameter, "NotInferrableTypeParameter");
            } else {
                ITypeSystemInferrer.InferenceResult typeArgument = (ITypeSystemInferrer.InferenceResult)argumentType.getBindings().get(i);
                this.inferTypeParameterFromOperationArgument(typeParameter, typeArgument, inferredTypeParameterTypes, acceptor);
            }
            ++i;
        }
    }

    protected ITypeSystemInferrer.InferenceResult doInferTypeParameterFromOperationArgument(TypeParameter typeParameter, ITypeSystemInferrer.InferenceResult argumentType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        Type newMappedType = argumentType.getType();
        ITypeSystemInferrer.InferenceResult typeInMap = this.resolveType(inferredTypeParameterTypes, typeParameter);
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        if (typeInMap == null) {
            _xifexpression = inferredTypeParameterTypes.put(typeParameter, ITypeSystemInferrer.InferenceResult.from((Type)newMappedType, (List)argumentType.getBindings()));
        } else {
            ITypeSystemInferrer.InferenceResult _xblockexpression_1 = null;
            Type commonType = this.getCommonType(argumentType, typeInMap);
            String errorMsg = String.format("Incompatible types %s and %s.", argumentType.toString(), typeInMap.toString());
            IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
            IValidationIssueAcceptor _function = it -> {
                thisIssueAcceptor.accept(it);
                acceptor.accept(it);
            };
            this.typeValidator.assertTypeBindingsSame(argumentType, typeInMap, errorMsg, _function);
            ITypeSystemInferrer.InferenceResult _xifexpression_1 = null;
            if (commonType == null || !thisIssueAcceptor.getTraces().isEmpty()) {
                inferredTypeParameterTypes.put(typeParameter, null);
                this.error(acceptor, String.format("Could not infer common type for type parameter %s from argument types %s.", typeParameter.getName(), CollectionLiterals.newArrayList((Object[])new String[]{argumentType.getType().getName(), typeInMap.getType().getName()})), "NotInferrableTypeParameter");
            } else {
                _xifexpression_1 = inferredTypeParameterTypes.put(typeParameter, ITypeSystemInferrer.InferenceResult.from((Type)commonType, (List)argumentType.getBindings()));
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Type getCommonType(ITypeSystemInferrer.InferenceResult type1, ITypeSystemInferrer.InferenceResult type2) {
        return this.registry.getCommonType(type1.getType(), type2.getType());
    }

    public ITypeSystemInferrer.InferenceResult buildInferenceResult(ITypeSystemInferrer.InferenceResult oldInferenceResult, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        Type oldInferredType;
        Type _type = null;
        if (oldInferenceResult != null) {
            _type = oldInferenceResult.getType();
        }
        if ((oldInferredType = _type) instanceof TypeParameter) {
            ITypeSystemInferrer.InferenceResult mappedType = this.resolveType(inferredTypeParameterTypes, (TypeParameter)oldInferredType);
            if (mappedType == null) {
                this.warning(acceptor, (TypeParameter)oldInferredType, "NotInferrableTypeParameter");
                return null;
            }
            return mappedType;
        }
        if (oldInferredType instanceof GenericElement) {
            ArrayList newBindings = CollectionLiterals.newArrayList();
            List _bindings = oldInferenceResult.getBindings();
            for (ITypeSystemInferrer.InferenceResult oldBinding : _bindings) {
                newBindings.add(this.buildInferenceResult(oldBinding, inferredTypeParameterTypes, acceptor));
            }
            return ITypeSystemInferrer.InferenceResult.from((Type)oldInferenceResult.getType(), (List)newBindings);
        }
        return oldInferenceResult;
    }

    protected ITypeSystemInferrer.InferenceResult resolveType(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, TypeParameter key) {
        ITypeSystemInferrer.InferenceResult res = inferredTypeParameterTypes.get(key);
        if (res == null) {
            return null;
        }
        Type _type = res.getType();
        if (_type instanceof TypeParameter) {
            Type _type_1 = res.getType();
            ITypeSystemInferrer.InferenceResult recursiveRes = this.resolveType(inferredTypeParameterTypes, (TypeParameter)_type_1);
            if (recursiveRes == null) {
                return res;
            }
            return recursiveRes;
        }
        return res;
    }

    public void inferTypeParametersFromOwner(ITypeSystemInferrer.InferenceResult operationOwnerResult, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        Type operationOwnerType;
        Type _type = null;
        if (operationOwnerResult != null) {
            _type = operationOwnerResult.getType();
        }
        if ((operationOwnerType = _type) instanceof GenericElement) {
            int i = 0;
            while (i < ((GenericElement)operationOwnerType).getTypeParameters().size() && i < operationOwnerResult.getBindings().size()) {
                TypeParameter typeParameter = (TypeParameter)((GenericElement)operationOwnerType).getTypeParameters().get(i);
                ITypeSystemInferrer.InferenceResult binding = (ITypeSystemInferrer.InferenceResult)operationOwnerResult.getBindings().get(i);
                inferredTypeParameterTypes.put(typeParameter, binding);
                ++i;
            }
            this.inferTypeParametersFromSuperTypes(operationOwnerType, inferredTypeParameterTypes);
        }
    }

    protected void inferTypeParametersFromSuperTypes(Type operationOwnerType, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        EList superTypes = operationOwnerType.getSuperTypes();
        for (TypeSpecifier superType : superTypes) {
            boolean _not;
            boolean _eIsProxy = superType.getType().eIsProxy();
            boolean bl = _not = !_eIsProxy;
            if (_not) {
                int i = 0;
                while (i < superType.getTypeArguments().size()) {
                    ITypeSystemInferrer.InferenceResult argument = this._iTypeSystemInferrer.infer((EObject)superType.getTypeArguments().get(i));
                    Type _type = superType.getType();
                    TypeParameter param = (TypeParameter)((GenericElement)_type).getTypeParameters().get(i);
                    inferredTypeParameterTypes.put(param, argument);
                    ++i;
                }
            }
            this.inferTypeParametersFromSuperTypes(superType.getType(), inferredTypeParameterTypes);
        }
    }

    protected void assertArgumentAndParameterSoftCompatible(ITypeSystemInferrer.InferenceResult argumentResult, TypeSpecifier parameter, IValidationIssueAcceptor acceptor) {
        Type _type = null;
        if (parameter != null) {
            _type = parameter.getType();
        }
        if (_type instanceof TypeParameter) {
            return;
        }
        if (argumentResult == null) {
            return;
        }
        ITypeSystemInferrer.InferenceResult result1 = ITypeSystemInferrer.InferenceResult.from((Type)argumentResult.getType());
        ITypeSystemInferrer.InferenceResult result2 = ITypeSystemInferrer.InferenceResult.from((Type)parameter.getType());
        IValidationIssueAcceptor.ListBasedValidationIssueAcceptor thisIssueAcceptor = this.createIssueAcceptor();
        IValidationIssueAcceptor _function = it -> {
            thisIssueAcceptor.accept(it);
            acceptor.accept(it);
        };
        this.typeValidator.assertCompatible(result1, result2, null, _function);
        if (thisIssueAcceptor.getTraces().isEmpty() && parameter.getTypeArguments() != null && parameter.getTypeArguments().size() != argumentResult.getBindings().size()) {
            Functions.Function1 _function_1 = it -> ITypeSystemInferrer.InferenceResult.from((Type)it.getType());
            List bindings = ListExtensions.map((List)parameter.getTypeArguments(), (Functions.Function1)_function_1);
            if (result1 != null && this.typeValidator.isAnyType(result1.getType())) {
                return;
            }
            IValidationIssueAcceptor _function_2 = it -> {
                thisIssueAcceptor.accept(it);
                acceptor.accept(it);
            };
            this.typeValidator.assertCompatible(argumentResult, (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)bindings), String.format("Incompatible types %s and %s.", argumentResult, ITypeSystemInferrer.InferenceResult.from((Type)parameter.getType(), (List)bindings)), _function_2);
        }
    }

    public void inferTypeParametersFromTargetType(ITypeSystemInferrer.InferenceResult operationTargetResult, Operation op, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes, IValidationIssueAcceptor acceptor) {
        this.inferTypeParameterFromOperationArgument(op.getTypeSpecifier(), operationTargetResult, inferredTypeParameterTypes, acceptor);
    }

    protected IValidationIssueAcceptor.ListBasedValidationIssueAcceptor createIssueAcceptor() {
        return new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
    }

    protected void error(IValidationIssueAcceptor acceptor, String msg, String issueCode) {
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void error(IValidationIssueAcceptor acceptor, TypeSpecifier typeSpecifier, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeSpecifier.getType().getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, _format, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void error(IValidationIssueAcceptor acceptor, TypeParameter typeParameter, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeParameter.getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, _format, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void warning(IValidationIssueAcceptor acceptor, String msg, String issueCode) {
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, msg, issueCode);
        acceptor.accept(_validationIssue);
    }

    protected void warning(IValidationIssueAcceptor acceptor, TypeParameter typeParameter, String issueCode) {
        String _format = String.format("Could not infer type for type parameter %s.", typeParameter.getName());
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, _format, issueCode);
        acceptor.accept(_validationIssue);
    }
}

