/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.terminals;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class IDWithKeywordsValueConverter
implements IValueConverter<String>,
IValueConverter.RuleSpecific {
    private static final Logger log = Logger.getLogger(IDWithKeywordsValueConverter.class);
    @Inject
    protected IValueConverterService converterService;
    protected AbstractRule rule;
    protected TerminalRule valueTerminalRule;
    protected HashSet<String> matchingKeywords = new HashSet();

    public String toString(String value) throws ValueConverterException {
        if (this.matchingKeywords.contains(value) || this.valueTerminalRule == null) {
            return value;
        }
        String _name = null;
        if (this.valueTerminalRule != null) {
            _name = this.valueTerminalRule.getName();
        }
        return this.converterService.toString((Object)value, _name);
    }

    public String toValue(String string, INode node) throws ValueConverterException {
        Object _xifexpression = null;
        if (this.matchingKeywords.contains(string) || this.valueTerminalRule == null) {
            _xifexpression = string;
        } else {
            String _name = null;
            if (this.valueTerminalRule != null) {
                _name = this.valueTerminalRule.getName();
            }
            _xifexpression = this.converterService.toValue(string, _name, node);
        }
        String idValue = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = idValue instanceof String ? idValue : string;
        return _xifexpression_1;
    }

    public void setRule(AbstractRule rule) throws IllegalArgumentException {
        this.rule = rule;
        this.valueTerminalRule = null;
        this.matchingKeywords.clear();
        if (rule != null) {
            this.matchingKeywords.addAll(this.collectAllKeywords(rule));
        }
    }

    protected Set<String> collectAllKeywords(AbstractRule rule) {
        boolean _equals;
        HashSet<String> keywords = new HashSet<String>();
        HashSet<AbstractRule> visited = new HashSet<AbstractRule>();
        HashSet<TerminalRule> terminals = new HashSet<TerminalRule>();
        this.collectKeywordsRecursive(rule, keywords, visited, terminals);
        int _size = terminals.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No terminal rule found in rule \"");
            String _name = rule.getName();
            _builder.append(_name);
            _builder.append("\". Expect rule calls a terminal rule (transitively).");
            log.warn((Object)_builder);
        } else {
            boolean _greaterThan;
            int _size_1 = terminals.size();
            boolean bl2 = _greaterThan = _size_1 > 1;
            if (_greaterThan) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Found multiple terminal rules referenced by \"");
                String _name_1 = rule.getName();
                _builder_1.append(_name_1);
                _builder_1.append("\": ");
                boolean _hasElements = false;
                for (TerminalRule r : terminals) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)", ", "");
                    }
                    _builder_1.append("\"");
                    String _name_2 = r.getName();
                    _builder_1.append(_name_2);
                    _builder_1.append("\"");
                }
                _builder_1.append(". Expected a single reference. Ignore all terminal rules.");
                log.warn((Object)_builder_1);
            } else {
                this.valueTerminalRule = (TerminalRule)IterableExtensions.head(terminals);
            }
        }
        return keywords;
    }

    protected void collectKeywordsRecursive(AbstractRule rule, Set<String> keywords, Set<AbstractRule> visited, Set<TerminalRule> terminals) {
        if (rule == null || visited.contains(rule)) {
            return;
        }
        visited.add(rule);
        Functions.Function1 _function = it -> it.getValue();
        keywords.addAll(ListExtensions.map((List)GrammarUtil.containedKeywords((EObject)rule), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.getRule();
        Consumer<AbstractRule> _function_2 = it -> {
            if (it instanceof TerminalRule) {
                terminals.add((TerminalRule)it);
            } else {
                this.collectKeywordsRecursive((AbstractRule)it, keywords, visited, terminals);
            }
        };
        ListExtensions.map((List)GrammarUtil.containedRuleCalls((EObject)rule), (Functions.Function1)_function_1).forEach(_function_2);
    }
}

