/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.InitializationExpression;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.NullLiteral;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ExpressionExtensions {
    @Inject
    @Extension
    protected IQualifiedNameProvider _iQualifiedNameProvider;

    protected List<ArgumentExpression> _toCallStack(FeatureCall call) {
        ArrayList _xblockexpression = null;
        ArrayList callStack = Lists.newArrayList();
        callStack.addAll(this.toCallStack(call.getOwner()));
        callStack.add(call);
        _xblockexpression = callStack;
        return _xblockexpression;
    }

    protected List<ArgumentExpression> _toCallStack(ElementReferenceExpression ex) {
        return Lists.newArrayList((Object[])new ArgumentExpression[]{ex});
    }

    protected List<ArgumentExpression> _toCallStack(Expression ex) {
        return Collections.emptyList();
    }

    protected EObject _featureOrReference(Void it) {
        return null;
    }

    protected EObject _featureOrReference(Expression it) {
        return null;
    }

    protected EObject _featureOrReference(FeatureCall it) {
        return it.getFeature();
    }

    protected EObject _featureOrReference(ElementReferenceExpression it) {
        return it.getReference();
    }

    protected ComplexType _getOriginType(InitializationExpression it) {
        return null;
    }

    protected ComplexType _getOriginType(EventRaisingExpression it) {
        return null;
    }

    protected ComplexType _getOriginType(Expression it) {
        return null;
    }

    public List<Type> allTypes(Type it, List<Type> tl) {
        List<Type> _xblockexpression = null;
        if (it instanceof ComplexType) {
            Consumer<Property> _function = ct -> {
                if (ct instanceof ComplexType) {
                    this.allTypes((Type)((ComplexType)ct), tl);
                }
                tl.add(ct.getType());
            };
            Iterables.filter((Iterable)((ComplexType)it).getFeatures(), Property.class).forEach(_function);
        } else {
            tl.add(it);
        }
        _xblockexpression = tl;
        return _xblockexpression;
    }

    protected Object _literalValue(IntLiteral literal) {
        long _value = literal.getValue();
        return _value;
    }

    protected Object _literalValue(BoolLiteral bool) {
        return bool.isValue();
    }

    protected Object _literalValue(DoubleLiteral literal) {
        return literal.getValue();
    }

    protected Object _literalValue(FloatLiteral literal) {
        return Float.valueOf(literal.getValue());
    }

    protected Object _literalValue(StringLiteral literal) {
        return literal.getValue();
    }

    protected Object _literalValue(NullLiteral literal) {
        return null;
    }

    @XbaseGenerated
    public List<ArgumentExpression> toCallStack(Expression ex) {
        if (ex instanceof ElementReferenceExpression) {
            return this._toCallStack((ElementReferenceExpression)ex);
        }
        if (ex instanceof FeatureCall) {
            return this._toCallStack((FeatureCall)ex);
        }
        if (ex != null) {
            return this._toCallStack(ex);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ex).toString());
    }

    @XbaseGenerated
    public EObject featureOrReference(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._featureOrReference((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._featureOrReference((FeatureCall)it);
        }
        if (it != null) {
            return this._featureOrReference(it);
        }
        return this._featureOrReference((Void)null);
    }

    @XbaseGenerated
    public ComplexType getOriginType(Expression it) {
        if (it instanceof EventRaisingExpression) {
            return this._getOriginType((EventRaisingExpression)it);
        }
        if (it instanceof InitializationExpression) {
            return this._getOriginType((InitializationExpression)it);
        }
        if (it != null) {
            return this._getOriginType(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public Object literalValue(Literal bool) {
        if (bool instanceof BoolLiteral) {
            return this._literalValue((BoolLiteral)bool);
        }
        if (bool instanceof DoubleLiteral) {
            return this._literalValue((DoubleLiteral)bool);
        }
        if (bool instanceof FloatLiteral) {
            return this._literalValue((FloatLiteral)bool);
        }
        if (bool instanceof IntLiteral) {
            return this._literalValue((IntLiteral)bool);
        }
        if (bool instanceof NullLiteral) {
            return this._literalValue((NullLiteral)bool);
        }
        if (bool instanceof StringLiteral) {
            return this._literalValue((StringLiteral)bool);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bool).toString());
    }
}

