/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;

public class CompoundCommand
extends Command {
    private final List<Command> commandList = new ArrayList<Command>();

    public CompoundCommand() {
    }

    public CompoundCommand(String label) {
        super(label);
    }

    public void add(Command command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    @Override
    public boolean canRedo() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        for (Command cmd : this.commandList) {
            if (cmd == null) {
                return false;
            }
            if (cmd.canRedo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canExecute() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        for (Command cmd : this.commandList) {
            if (cmd == null) {
                return false;
            }
            if (cmd.canExecute()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUndo() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        for (Command cmd : this.commandList) {
            if (cmd == null) {
                return false;
            }
            if (cmd.canUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.commandList.forEach(Command::dispose);
    }

    @Override
    public void execute() {
        this.commandList.forEach(Command::execute);
    }

    public Object[] getChildren() {
        return this.commandList.toArray();
    }

    public List<? extends Command> getCommands() {
        return this.commandList;
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.commandList.isEmpty()) {
            return null;
        }
        if (label != null) {
            return label;
        }
        return this.commandList.get(0).getLabel();
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    @Override
    public void redo() {
        this.commandList.forEach(Command::redo);
    }

    public int size() {
        return this.commandList.size();
    }

    @Override
    public void undo() {
        int i = this.commandList.size() - 1;
        while (i >= 0) {
            this.commandList.get(i).undo();
            --i;
        }
    }

    public Command unwrap() {
        return switch (this.commandList.size()) {
            case 0 -> UnexecutableCommand.INSTANCE;
            case 1 -> this.commandList.get(0);
            default -> this;
        };
    }
}

