/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.commons.WorkspaceClassLoaderFactory;
import com.yakindu.sct.domain.java.resource.JavaResource;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

@Singleton
public class ClassLoaderProvider {
    @Inject
    protected WorkspaceClassLoaderFactory classLoaderFactory;
    protected Map<IProject, ClassLoader> classLoaders = Maps.newHashMap();

    public ClassLoader get(JavaResource resource) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getContextProject());
        return this.classLoaders.computeIfAbsent(project, p -> this.classLoaderFactory.createClassLoader(p, this.getClass().getClassLoader()));
    }
}

