/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.intro;

import com.yakindu.sct.ui.intro.Activator;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class ReleaseNotes
implements IStartup {
    protected static final String RELEASE_NOTES = "https://www.itemis.com/en/yakindu/state-machine/documentation/user-guide/release_notes_{0}?source=product";

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    String currentVersion = ReleaseNotes.this.getCurrentVersion();
                    String lastVersion = ReleaseNotes.this.getLastVersion();
                    if (lastVersion.isEmpty()) {
                        ReleaseNotes.this.setLastVersion(currentVersion);
                        return;
                    }
                    if (!currentVersion.equals(lastVersion)) {
                        ReleaseNotes.this.setLastVersion(currentVersion);
                        ReleaseNotes.this.openReleaseNotes(currentVersion);
                    }
                }
            }
        });
    }

    protected String getLastVersion() {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode(ReleaseNotes.class.getName());
        return node.get(Version.class.getSimpleName(), "");
    }

    protected void setLastVersion(String version) {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode(ReleaseNotes.class.getName());
        node.put(Version.class.getSimpleName(), version);
        try {
            node.flush();
            return;
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return;
        }
    }

    protected void openReleaseNotes(String installationVersion) {
        try {
            URL url = new URL(MessageFormat.format(RELEASE_NOTES, installationVersion));
            PlatformUI.getWorkbench().getBrowserSupport().createBrowser("com.yakindu.sct").openURL(url);
        }
        catch (MalformedURLException | PartInitException e) {
            e.printStackTrace();
        }
    }

    protected String getCurrentVersion() {
        Version currentVersion = Activator.getDefault().getBundle().getVersion();
        return currentVersion.getMajor() + "." + currentVersion.getMinor() + "." + currentVersion.getMicro();
    }
}

