/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.base.generator.csharp.artifacts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.artifacts.IContent;
import com.itemis.create.base.generator.core.artifacts.IGenArtifact;
import com.itemis.create.base.generator.core.types.Literals;
import com.itemis.create.base.generator.csharp.codemodel.CsharpStatemachineLibrary;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CsharpVirtualTimer
implements IContent,
IGenArtifact {
    @Inject
    @Extension
    protected CsharpStatemachineLibrary _csharpStatemachineLibrary;
    @Inject
    @Extension
    protected Literals _literals;

    public String content() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("using System;");
        _builder.newLine();
        _builder.append("using System.Collections.Generic;");
        _builder.newLine();
        _builder.append("using System.Numerics;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public class VirtualTimer : ITimerService");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("private BigInteger stopTime = BigInteger.Zero;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected BigInteger currentTime = BigInteger.Zero;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected long cyclePeriod = 0;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected BigInteger scheduleCount = BigInteger.Zero;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("private SortedSet<VirtualTimeTask> tasks;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public abstract class VirtualTimeTask : IComparable<VirtualTimeTask>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public BigInteger nextExecutionTime = BigInteger.Zero;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public long interval = 0;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public long period = -1;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public BigInteger scheduleOrder = BigInteger.Zero;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public bool isCanceled = false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public int CompareTo(VirtualTimeTask other)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("BigInteger diff = BigInteger.Zero;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (!nextExecutionTime.Equals(other.nextExecutionTime))");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("diff = nextExecutionTime - other.nextExecutionTime;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("else if (other is CycleTimeEventTask && this is not CycleTimeEventTask)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("return -1;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("else if (other is not CycleTimeEventTask && this is CycleTimeEventTask)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("return 1;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("diff = scheduleOrder - other.scheduleOrder;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("return diff.CompareTo(BigInteger.Zero);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public bool IsCanceled()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("return isCanceled;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public void Cancel()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("isCanceled = true;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public abstract void Run();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public class VirtualTimeEventTask : VirtualTimeTask");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("private readonly int eventID;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("private readonly ITimed callback;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public VirtualTimeEventTask(ITimed callback, int eventID)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("this.callback = callback;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("this.eventID = eventID;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public int GetEventId()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("return eventID;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public ITimed GetCallback()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("return callback;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public override void Run()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("callback.RaiseTimeEvent(eventID);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public class CycleTimeEventTask : VirtualTimeTask");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public readonly ");
        String _asLiteral = this._literals.asLiteral((Object)this._csharpStatemachineLibrary.cycleBasedStatemachineInterface());
        _builder.append(_asLiteral, "            ");
        _builder.append(" statemachine;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public CycleTimeEventTask(");
        String _asLiteral_1 = this._literals.asLiteral((Object)this._csharpStatemachineLibrary.cycleBasedStatemachineInterface());
        _builder.append(_asLiteral_1, "            ");
        _builder.append(" statemachine)");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("this.statemachine = statemachine;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("public override void Run()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            \t");
        _builder.append("statemachine.RunCycle();");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public VirtualTimer()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("tasks = new SortedSet<VirtualTimeTask>();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public VirtualTimer(long cyclePeriod)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("tasks = new SortedSet<VirtualTimeTask>();");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("this.cyclePeriod = cyclePeriod;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void TimeLeap(long ms)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("stopTime = currentTime + new BigInteger(ms);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("ProcessTasks();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void CycleLeap(long cycles)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("int elapsedCycles = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("while (elapsedCycles < cycles)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("VirtualTimeTask cycleTask = GetCycleTask();");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (cycleTask == null)");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("return;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                ");
        _builder.append("BigInteger timeToNextCycle = BigInteger.Subtract(cycleTask.nextExecutionTime, currentTime);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("TimeLeap((long)timeToNextCycle);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("elapsedCycles += 1;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void SetTimer(ITimed callback, int eventID, long duration, bool isPeriodical)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("if (duration <= 0)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("duration = 1;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("VirtualTimeEventTask timeEventTask = new(callback, eventID);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("if (isPeriodical)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("SchedulePeriodicalTask(timeEventTask, duration, duration);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ScheduleTask(timeEventTask, duration);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void UnsetTimer(ITimed callback, int eventID)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("VirtualTimeTask timerTask = GetTask(callback, eventID);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("timerTask?.Cancel();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void ScheduleTask(VirtualTimeTask task, long interval)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("task.interval = interval;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("ScheduleInternal(task, currentTime + new BigInteger(interval), -1);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void SchedulePeriodicalTask(VirtualTimeTask task, long interval, long period)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("ScheduleInternal(task, currentTime + new BigInteger(interval), period);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("         ");
        _builder.append("private void ScheduleInternal(VirtualTimeTask task, BigInteger time, long period)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("task.nextExecutionTime = time;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("task.period = period;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("task.scheduleOrder = scheduleCount;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("scheduleCount += BigInteger.One;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("tasks.Add(task);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected VirtualTimeTask GetTask(ITimed callback, int eventName)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("foreach (VirtualTimeTask virtualTimeTask in tasks)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (virtualTimeTask is not VirtualTimeEventTask)");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (((VirtualTimeEventTask)virtualTimeTask).GetEventId() == eventName");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("&& ((VirtualTimeEventTask)virtualTimeTask).GetCallback() == callback)");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("return virtualTimeTask;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected CycleTimeEventTask GetCycleTask()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("foreach (VirtualTimeTask task in tasks)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (task is CycleTimeEventTask task1 && !task.IsCanceled())");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("return task1;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("protected void ProcessTasks()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("bool processTasks = tasks.Count > 0;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("while (processTasks)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("VirtualTimeTask task = tasks.Min;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (task == null)");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (task.isCanceled)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("tasks.Remove(task);");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("                ");
        _builder.append("if (task.nextExecutionTime.CompareTo(stopTime) <= 0)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("currentTime = task.nextExecutionTime;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("tasks.Remove(task);");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("if (task.period > -1)");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("tasks.Remove(task);");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("task.nextExecutionTime = currentTime + new BigInteger(task.period);");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("tasks.Add(task);");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("task.Run();");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("else");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("currentTime = stopTime;");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("processTasks = false;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void Stop()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("foreach (VirtualTimeTask timerTask in tasks)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("timerTask.Cancel();");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Cancel();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("public void Cancel()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("lock (tasks)");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("tasks.Clear();");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

