/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.generator.java.submodules.TimingFunctions
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenTimingFunctions extends TimingFunctions {
	
	@Inject protected extension EventQueue
	@Inject extension SExecExtensions
	@Inject extension GeneratorPredicate
	@Inject extension Synchronized
	@Inject extension Naming
	
	override timingFunctions(ExecutionFlow flow) '''
		«IF flow.timed»
			public «sync»void setTimerService(«iTimerService» «timerServiceInstance») {
				this.«timerServiceInstance» = «timerServiceInstance»;
			}
			
			public «iTimerService» getTimerService() {
				return «timerServiceInstance»;
			}
			
			public «sync»void raiseTimeEvent(int eventID) {
				«flow.traceTimeEventRaised('eventID')»
				«IF flow.requiresIncomingEventQueue»
				inEventQueue.add(() -> {
					timeEvents[eventID] = true;
					«IF needsRunnable»
					runCycle();
					«ENDIF»
				});
				«IF !needsRunnable»
				runCycle();
				«ENDIF»
				«ELSE»
				timeEvents[eventID] = true;
				runCycle();
				«ENDIF»
			}

		«ENDIF»
	'''
}