/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.scxml.modifications

import com.yakindu.base.expressions.expressions.AdditiveOperator
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.ReactionEffect
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.emf.ecore.EObject

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

class PostFixModification implements IModification {
	protected static extension ExpressionsFactory = ExpressionsFactory.eINSTANCE

	override modify(Statechart statechart) {
		val eContainers = newHashSet()
		eContainers.addAll(statechart.eAllContents.filter(PostFixUnaryExpression).map[eContainer].toSet)
		eContainers.forEach[replacePostFixUnaryExpressions]
	}

	def replacePostFixUnaryExpressions(EObject eo) {
		if (eo === null || !(eo instanceof ReactionEffect)) {
			return
		}
		val it = eo as ReactionEffect

		actions.replaceAll [
			switch (it) {
				PostFixUnaryExpression: replacePostFixUnaryExpression
				default: it
			}
		]
	}

	def replacePostFixUnaryExpression(PostFixUnaryExpression exp) {
		createAssignmentExpression => [
			operator = AssignmentOperator.ASSIGN
			expression = createNumericalAddSubtractExpression => [
				leftOperand = exp.operand.copy
				rightOperand = createPrimitiveValueExpression => [
					value = createIntLiteral => [
						value = 1
					]
				]
				operator = switch (exp.operator) {
					case INCREMENT: AdditiveOperator.PLUS
					case DECREMENT: AdditiveOperator.MINUS
				}
			]
			varRef = exp.operand.copy
		]

	}
}
