/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp.qt.providers

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.cpp.qt.QtExtensions
import com.yakindu.sct.generator.cpp11.Cpp11ConstructorProvider
import com.yakindu.sct.model.sexec.ExecutionFlow
import java.util.List
import com.yakindu.sct.model.stext.stext.StatechartScope

class QtConstructorProvider extends Cpp11ConstructorProvider {
	
	@Inject protected extension QtExtensions
	 
	override constructorDefinition(ExecutionFlow it){
	'''
		«module»::«module»(QObject *parent)«propertyThrowsException» :
			«initialisationList.generate»
		{
			«constructorBody(it)»
		}
	'''
	}

	override ifaceConstructorDefintion(ExecutionFlow it, StatechartScope iface) {
		'''
			«module»::«iface.interfaceName»::«iface.interfaceName»(«module»* «parentArgument»)«iface.propertyThrowsException» :
				«initialisationList(iface).generate»
			{
				«constructorBody(iface)»
			}
		'''
	}

	override dispatch add(List<Pair<String, String>> toInit, Event it) {
		if (requiresInitializer) super._add(toInit, it)
	}
	
	
}