/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.BaseExpressionCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.types.ArrayTypeSpecifier
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.base.types.typesystem.ITypeValueProvider

/**
 * The standard implementation pattern for variables. 
 * 
 * @author laszlo kovacs - Initial contribution.
 */
class VariableCode implements IVariableCode{
	
	@Inject protected extension ITypeValueProvider
	@Inject protected extension CsharpVisibility
	@Inject protected extension BaseExpressionCode baseExprCode
	@Inject protected extension ExpressionCode
	@Inject protected extension CodeComment
	@Inject protected extension ITypeSystem
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension OriginTracing
	@Inject protected extension CsharpLiterals
	@Inject protected extension CsharpClass
		
	def dispatch dispatchVariableDeclarationCode(Property it) '''
		«codeComment»
		«csharpVisibility»«IF !const && static» static«ENDIF»«IF const» const«ENDIF» «declType» «typeSpecifier.asLiteral»«IF type.nullable»?«ENDIF»«arrayType» «name»«IF !eContainer.isCsharpInterface && !isEvent» = «initValue»«ENDIF»;
	'''
	
	def dispatch dispatchVariableDeclarationCode(Part it) '''
		«codeComment»
		«csharpVisibility»«IF !const && static» static«ENDIF»«IF const» const«ENDIF» «declType» «typeSpecifier.asLiteral»«type.specifyGenericType» «name» «IF !isRequired && !isEvent»= «instantiationCode»«ENDIF»;
	'''
	
	def protected inClassInit(Property it){
		if(initialValue === null) false
		else true
	}
	
	def protected initValue(Property it){
		if (initialValue !== null) {			
			//Don't use default when the default value isn't NullLiteral. This caused issue when instantiating the 'stateconfVector'.
			val isNullLiteral = initialValue instanceof PrimitiveValueExpression && (initialValue as PrimitiveValueExpression).value instanceof NullLiteral
			
			if (!isNullLiteral)
				return baseExprCode.code(initialValue)
		}
		if(it.type instanceof EnumerationType || it.type instanceof ComplexType)
			return '''default'''
		if(type.eResource !== null) {
			val defVal = type.defaultValue
			if(defVal !== null)
				return defVal.asLiteral		
		}
		else
			return '''null'''
	}

	
	def arrayType(Property it){
		if(typeSpecifier instanceof ArrayTypeSpecifier) '''[]'''
	}
	
	override variableDeclarationCode(Property it) {
		dispatchVariableDeclarationCode
	}
	
}
