/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.FlowCode
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sexec.concepts.HaltBehavior

/**
 * @author axel terfloth
 */
class InternalFunctions {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension FlowCode
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers
	@Inject protected extension TriggerWithoutEventMethod
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension Documentation
	@Inject protected extension HaltBehavior
	
	def functionImplementations(ExecutionFlow it) '''
		// implementations of all internal functions
		«checkFunctions.toImplementation»
		«effectFunctions.toImplementation»
		«entryActionFunctions.toImplementation»
		«exitActionFunctions.toImplementation»
		«enterSequenceFunctions.toImplementation»
		«exitSequenceFunctions.toImplementation»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toList.toImplementation»
		«reactMethods.toDefinitions»
		«methods.toDefinitions»
		«IF hasTriggerWithoutEvents»
		«implementation(triggerWithoutEvents)»
		«ENDIF»
		«IF hasHalt»
		«implementation(halt)»
		«ENDIF»
		«IF hasIsHalted»
		«implementation(isHalted)»
		«ENDIF»
		
	'''
	
	 def toDefinitions(Iterable<Method> methods){'''
	 	«FOR m : methods»
	 		«implementation(m)»
	 		
	 	«ENDFOR»
	 '''}
	 
	 def dispatch implementation(Method it) '''
	 	«typeSpecifier.targetLanguageName» «execution_flow.module»::«shortName»(«FOR p : parameters SEPARATOR ', '»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR»)«IF noException»«_noexcept»«ENDIF» {
	 		«body.code»
	 	}
	 '''
	 
	 def dispatch implementation(Operation it) '''
	 	/* «documentation» */
	 	«typeSpecifier.targetLanguageName» «execution_flow.module»::«name»(«FOR p : parameters SEPARATOR ', '»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR») «implementation.code»
	 '''
	 
	def toImplementation(Iterable<Step> steps) '''
		«FOR s : steps»
			«s.functionImplementation»
		«ENDFOR»
	'''
	
	def dispatch functionImplementation(Check it) '''
		«stepComment»
		«sc_bool.fqName» «execution_flow.module»::«shortName»()
		{
			return «code»;
		}
		
	'''
	
	def dispatch functionImplementation(Step it) '''
		«stepComment»
		void «execution_flow.module»::«shortName»()
		{
			«code»
		}
		
	'''
	
	def prototypes(ExecutionFlow it) '''
		// prototypes of all internal functions
		
		«checkFunctions.toPrototypes»
		«effectFunctions.toPrototypes»
		«entryActionFunctions.toPrototypes»
		«exitActionFunctions.toPrototypes»
		«enterSequenceFunctions.toPrototypes»
		«exitSequenceFunctions.toPrototypes»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toPrototypes»
		«reactMethods.toDeclarations»
		«methods.filter[!isPublic].toDeclarations»
		
	'''
	
	def toDeclarations(Iterable<Method> steps) '''
		«FOR s : steps»
			«s.toPrototype»
		«ENDFOR»
	'''
	
	def toPrototype(Method it) '''
		«typeSpecifier.targetLanguageName» «shortName»(«FOR p : parameters SEPARATOR ', '»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR»)«IF noException»«_noexcept»«ENDIF»;
	'''
	
	def toPrototypes(Iterable<Step> steps) '''
		«FOR s : steps»
			«s.functionPrototype»
		«ENDFOR»
	'''

	def dispatch functionPrototype(Check it) '''
		«sc_bool.fqName» «shortName»();
	'''

	def dispatch functionPrototype(Step it) '''
		void «shortName»();
	'''
}