/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * 
 * @author axel terfloth - Initial contribution.
 */
class Cpp11Naming extends CppNaming {

	@Inject protected extension StateEnum
	@Inject protected extension Literals
	@Inject protected extension CppExpressionsGenerator
	
	@Inject GeneratorEntry entry
	
	override stateVectorDefine(ExecutionState it) {
		'''scvi_«shortName»'''
	}

	override dispatch localValueAccess(Event it) '''
		«IF typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)»
			std::move(«name.asIdentifier.value»)«ELSE»
			«name.asIdentifier.value»«ENDIF»'''
	
	override statesEnumType(ExecutionFlow it) {
		stateEnum.name
	}

	override stateName(RegularState it) {
		enumerator.asLiteral
	}

	override stateName(ExecutionState it) {
		enumerator.asLiteral
	}

	override dispatch String null_state(ExecutionFlow it) {
		noStateEnumerator.asLiteral
	}

	override ifaceAcces() {
		"."
	}

	override ifaceReference() {
		"&"
	}

	override ifaceAsReference() {
		""
	}
	
	override OCB_InterfaceSetterDeclaration(StatechartScope scope, boolean fqn){ 
	if(entry.usePlainOperationCallbackPointers) super.OCB_InterfaceSetterDeclaration(scope, fqn)
	else '''
	void «IF fqn»«scope.flow.module»::«scope.scopedAccess»«ENDIF»set«scope.interfaceOCBName»(«sharedPtr»«scope.interfaceOCBName»«pointerType» operationCallback)'''
	}
	
}
