/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * @author axel terfloth
 */
class Cpp11ProtectedClassMemberProvider implements ISourceFragment {
	
	@Inject protected extension CodeModel
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension GeneratorAssignment
	

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) '''
		
		«FOR e : implementationClass.features.filter[isProtected]»
			
			«e.declarationCode»
		«ENDFOR»
		
	'''	
	
}
