/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.codepattern.CppScopeTypeDeclarationCode

/**
 * The standard implementation pattern for variables. 
 * 
 * TODO: Clean up implementation and inheritance hierarchy
 * 
 * @author axel terfloth - Initial contribution.
 */
class VariableCode extends CppScopeTypeDeclarationCode implements IVariableCode {
	
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension CppExpressionsGenerator expressions
	@Inject protected extension CppSpecifiers
	@Inject protected extension DoxygenComment
	@Inject protected extension Naming
	@Inject protected extension ITypeSystem
	
	override variableDeclarationCode(Property it) {
		variableDeclarationCode(name)
	}
	
	def dispatch variableDeclarationCode(Property it, String escapedName) '''
		«codeComment»
		«IF const || static»static«type._constexpr» «ENDIF»«IF const»const «ENDIF»«typeSpecifier.targetLanguageName» «escapedName» «IF inClassInit»«calculateInitialValue»«ENDIF»;
	'''
	
	override dispatch scopeTypeDeclMember(Property it){
		variableDeclarationCode(name.asEscapedIdentifier)
	}
	
	def protected inClassInit(Property it){
		if(type.isString && (const || static)) false
		else true
	}
	
	def dispatch variableDeclarationCode(ComplexType it, String escapedName)
		'''
		«codeComment»
		«name.toFirstUpper» «name» = new «name.toFirstUpper»();
	'''
	
}