/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration

/**
 * An event driven state machine may be triggered without event. 
 * Such a trigger will execute the state machines run to completion step. 
 * 
 * @author axel terfloth
 */
@Singleton
class TriggerWithoutEventMethod {

	public static val TRIGGER_WITHOUT_EVENT = "triggerWithoutEvent"

	@Inject protected extension RunCycleMethod
	@Inject protected extension SExecExtensions
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension Documentation
	@Inject protected IFlowConfiguration config
	

	def needsTriggerWithoutEvents(ExecutionFlow it) {
		config.isEventDriven
	}
	
	def defineFeatures (ExecutionFlow it) {
		if (needsTriggerWithoutEvents) {
			defineTriggerWithoutEvent				
		}
	}
	
	def protected defineTriggerWithoutEvent(ExecutionFlow it) {
		
		it.features += _op(TRIGGER_WITHOUT_EVENT) => [ m |
			m.documentation("Can be used by the client code to trigger a run to completion step without raising an event.")
			m._public
			m._type(_void)
			m.implementation = _block (
				runCycle._call
			)
		]
	}
	
	def Operation triggerWithoutEvents(ExecutionFlow it) {
		features.filter( typeof(Operation) ).filter( m | m.name == TRIGGER_WITHOUT_EVENT).head		
	}
	
	def hasTriggerWithoutEvents(ExecutionFlow it) {
		triggerWithoutEvents !== null		
	}
	
	
	
}