/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.simulation.core.interpreter;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.interpreter.IOperationExecutor;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.simulation.core.sexec.interpreter.DefaultOperationMockup;
import com.yakindu.sct.simulation.core.util.ExecutionContextExtensions;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import com.yakindu.sctunit.simulation.core.junit.Failure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * @author jonathan thoene - Initial contribution and API
 */
@SuppressWarnings("all")
public class DefaultSCTUnitFailureTracer implements IFailureTracer {
  @Inject
  protected ITypeSystemInferrer tsi;

  @Inject
  protected IExecutionSlotResolver resolver;

  @Inject
  @Extension
  protected ExecutionContextExtensions _executionContextExtensions;

  @Inject
  protected Set<IOperationExecutor> operationMockups;

  @Override
  public Failure getFailureStack(final AssertionStatement assertion, final ExecutionContext it) {
    final Function1<EObject, Boolean> _function = (EObject elem) -> {
      return Boolean.valueOf((((elem instanceof ArgumentExpression) && this.doEvaluate(((ArgumentExpression) elem))) || (elem instanceof ActiveStateReferenceExpression)));
    };
    Iterator<EObject> allRefs = IteratorExtensions.<EObject>filter(assertion.eAllContents(), _function);
    final Function1<EObject, String> _function_1 = (EObject elem) -> {
      return this.failureMessage(elem, it);
    };
    final List<String> failures = IteratorExtensions.<String>toList(IteratorExtensions.<EObject, String>map(allRefs, _function_1));
    Failure _failure = new Failure();
    final Procedure1<Failure> _function_2 = (Failure it_1) -> {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Assertion failed: \"");
      CharSequence _assertionMessage = this.getAssertionMessage(assertion);
      _builder.append(_assertionMessage);
      _builder.append("\" (Line ");
      int _startLine = NodeModelUtils.getNode(assertion).getStartLine();
      _builder.append(_startLine);
      _builder.append(")");
      _builder.newLineIfNotEmpty();
      {
        for(final String failure : failures) {
          _builder.append("\t");
          _builder.append(failure, "\t");
          _builder.newLineIfNotEmpty();
        }
      }
      it_1.setMessage(_builder.toString());
    };
    Failure failure = ObjectExtensions.<Failure>operator_doubleArrow(_failure, _function_2);
    return failure;
  }

  @Override
  public Failure getFailureStack(final VerifyCalledStatement it, final List<Object> calledParameters) {
    final String operation = this.getOperation(it.getReference()).getName();
    if (((it.isNegated() && (!this.getMockup().wasNotCalled(operation, calledParameters))) || ((!it.isNegated()) && (!this.getMockup().wasCalledAtLeast(operation, calledParameters, it.getTimes()))))) {
      Failure _failure = new Failure();
      final Procedure1<Failure> _function = (Failure f) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Assertion failed: \"");
        CharSequence _assertionMessage = this.getAssertionMessage(it);
        _builder.append(_assertionMessage);
        _builder.append("\" (Line ");
        int _startLine = NodeModelUtils.getNode(it).getStartLine();
        _builder.append(_startLine);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _verifyCalledStatementMessage = this.verifyCalledStatementMessage(it, calledParameters);
        _builder.append(_verifyCalledStatementMessage, "\t");
        _builder.newLineIfNotEmpty();
        f.setMessage(_builder.toString());
      };
      Failure failure = ObjectExtensions.<Failure>operator_doubleArrow(_failure, _function);
      return failure;
    } else {
      return null;
    }
  }

  public DefaultOperationMockup getMockup() {
    return IterableExtensions.<DefaultOperationMockup>head(Iterables.<DefaultOperationMockup>filter(this.operationMockups, DefaultOperationMockup.class));
  }

  public CharSequence verifyCalledStatementMessage(final VerifyCalledStatement it, final List<Object> calledParameters) {
    CharSequence _xblockexpression = null;
    {
      long _switchResult = (long) 0;
      boolean _matched = false;
      boolean _isNegated = it.isNegated();
      if (_isNegated) {
        _matched=true;
        _switchResult = 0;
      }
      if (!_matched) {
        IntLiteral _times = it.getTimes();
        boolean _tripleNotEquals = (_times != null);
        if (_tripleNotEquals) {
          _matched=true;
          _switchResult = it.getTimes().getValue();
        }
      }
      if (!_matched) {
        _switchResult = 1;
      }
      long expectedCount = _switchResult;
      String _xifexpression = null;
      if (((calledParameters != null) && (!calledParameters.isEmpty()))) {
        String _string = calledParameters.toString();
        String _plus = ("\nwith parameters " + _string);
        _xifexpression = (_plus + ",\n");
      } else {
        _xifexpression = ",\n";
      }
      String parameters = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Expected operation ");
      String _name = this.getOperation(it.getReference()).getName();
      _builder.append(_name);
      _builder.append(" to be called ");
      CharSequence _times_1 = this.times(expectedCount);
      _builder.append(_times_1);
      _builder.append(" ");
      _builder.append(parameters);
      _builder.newLineIfNotEmpty();
      _builder.append("but it was called ");
      CharSequence _times_2 = this.times(this.getMockup().getOperationCallCount(this.getOperation(it.getReference()).getName(), calledParameters));
      _builder.append(_times_2);
      _builder.append(".");
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }

  public CharSequence times(final long times) {
    CharSequence _xifexpression = null;
    if ((times == 1)) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("1 time");
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(times);
      _builder_1.append(" times");
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }

  protected CharSequence _getAssertionMessage(final AssertionStatement it) {
    String _xifexpression = null;
    String _errorMsg = it.getErrorMsg();
    boolean _tripleNotEquals = (_errorMsg != null);
    if (_tripleNotEquals) {
      _xifexpression = it.getErrorMsg();
    } else {
      _xifexpression = NodeModelUtils.getTokenText(NodeModelUtils.getNode(it)).replace("\r", "").replace("\n", "").trim();
    }
    return StringEscapeUtils.escapeXml(_xifexpression);
  }

  protected CharSequence _getAssertionMessage(final TestStatement it) {
    return StringEscapeUtils.escapeXml(
      NodeModelUtils.getNode(it).getText().replace("\r", "").replace("\n", "").trim());
  }

  protected String _failureMessage(final EObject it, final ExecutionContext context) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }

  protected String _failureMessage(final ElementReferenceExpression it, final ExecutionContext context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("name: ");
    String _elemName = this.elemName(it.getReference());
    _builder.append(_elemName);
    _builder.append(", value: ");
    Object _value = this.value(context, it);
    _builder.append(_value);
    return _builder.toString();
  }

  protected String _failureMessage(final FeatureCall it, final ExecutionContext context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("name: ");
    String _elemName = this.elemName(it.getOwner());
    _builder.append(_elemName);
    _builder.append(".");
    String _elemName_1 = this.elemName(it.getFeature());
    _builder.append(_elemName_1);
    _builder.append(", value: ");
    Object _value = this.value(context, it);
    _builder.append(_value);
    return _builder.toString();
  }

  protected String _failureMessage(final ActiveStateReferenceExpression it, final ExecutionContext context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Expected: ");
    String _name = it.getValue().getName();
    _builder.append(_name);
    _builder.append(", actual: [");
    {
      List<RegularState> _allActiveStates = this._executionContextExtensions.getAllActiveStates(context);
      boolean _hasElements = false;
      for(final RegularState state : _allActiveStates) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _name_1 = state.getName();
        _builder.append(_name_1);
      }
    }
    _builder.append("]");
    return _builder.toString();
  }

  private String _elemName(final NamedElement it) {
    return it.getName();
  }

  private String _elemName(final EObject it) {
    return "";
  }

  private String _elemName(final ElementReferenceExpression it) {
    return this.elemName(it.getReference());
  }

  protected Operation _getOperation(final Expression it) {
    return null;
  }

  protected Operation _getOperation(final FeatureCall it) {
    EObject _feature = it.getFeature();
    return ((Operation) _feature);
  }

  protected Operation _getOperation(final ElementReferenceExpression it) {
    EObject _reference = it.getReference();
    return ((Operation) _reference);
  }

  protected Object _value(final ExecutionContext context, final Expression it) {
    ExecutionSlot _orElse = this.resolver.resolve(context, it).orElse(null);
    Object _value = null;
    if (_orElse!=null) {
      _value=_orElse.getValue();
    }
    return _value;
  }

  protected Object _value(final ExecutionContext context, final ElementReferenceExpression it) {
    ExecutionSlot _orElse = this.resolver.resolve(context, it).orElse(null);
    Object _value = null;
    if (_orElse!=null) {
      _value=_orElse.getValue();
    }
    final Object value = _value;
    final EnumerationType enumType = this.enumerationType(it);
    if ((enumType != null)) {
      EObject _reference = it.getReference();
      String _name = ((VariableDefinition) _reference).getTypeSpecifier().getType().getName();
      String _plus = (_name + ".");
      String _name_1 = ((Enumerator) value).getName();
      return (_plus + _name_1);
    }
    return value;
  }

  public EnumerationType enumerationType(final ElementReferenceExpression it) {
    final ITypeSystemInferrer.InferenceResult typeResult = this.tsi.infer(it);
    Type _type = null;
    if (typeResult!=null) {
      _type=typeResult.getType();
    }
    final Type type = _type;
    if ((type instanceof EnumerationType)) {
      return ((EnumerationType)type);
    }
    return null;
  }

  protected boolean _doEvaluate(final ElementReferenceExpression it) {
    boolean _switchResult = false;
    EObject _reference = it.getReference();
    boolean _matched = false;
    if (_reference instanceof Scope) {
      _matched=true;
      _switchResult = false;
    }
    if (!_matched) {
      if (_reference instanceof Type) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      _switchResult = true;
    }
    return _switchResult;
  }

  protected boolean _doEvaluate(final FeatureCall it) {
    boolean _switchResult = false;
    EObject _feature = it.getFeature();
    boolean _matched = false;
    if (_feature instanceof Enumerator) {
      _matched=true;
      _switchResult = false;
    }
    if (!_matched) {
      _switchResult = true;
    }
    return _switchResult;
  }

  protected boolean _doEvaluate(final ArgumentExpression it) {
    return false;
  }

  @XbaseGenerated
  protected CharSequence getAssertionMessage(final TestStatement it) {
    if (it instanceof AssertionStatement) {
      return _getAssertionMessage((AssertionStatement)it);
    } else if (it != null) {
      return _getAssertionMessage(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  protected String failureMessage(final EObject it, final ExecutionContext context) {
    if (it instanceof ElementReferenceExpression) {
      return _failureMessage((ElementReferenceExpression)it, context);
    } else if (it instanceof FeatureCall) {
      return _failureMessage((FeatureCall)it, context);
    } else if (it instanceof ActiveStateReferenceExpression) {
      return _failureMessage((ActiveStateReferenceExpression)it, context);
    } else if (it != null) {
      return _failureMessage(it, context);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, context).toString());
    }
  }

  @XbaseGenerated
  private String elemName(final EObject it) {
    if (it instanceof ElementReferenceExpression) {
      return _elemName((ElementReferenceExpression)it);
    } else if (it instanceof NamedElement) {
      return _elemName((NamedElement)it);
    } else if (it != null) {
      return _elemName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public Operation getOperation(final Expression it) {
    if (it instanceof ElementReferenceExpression) {
      return _getOperation((ElementReferenceExpression)it);
    } else if (it instanceof FeatureCall) {
      return _getOperation((FeatureCall)it);
    } else if (it != null) {
      return _getOperation(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public Object value(final ExecutionContext context, final Expression it) {
    if (it instanceof ElementReferenceExpression) {
      return _value(context, (ElementReferenceExpression)it);
    } else if (it != null) {
      return _value(context, it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(context, it).toString());
    }
  }

  @XbaseGenerated
  public boolean doEvaluate(final ArgumentExpression it) {
    if (it instanceof ElementReferenceExpression) {
      return _doEvaluate((ElementReferenceExpression)it);
    } else if (it instanceof FeatureCall) {
      return _doEvaluate((FeatureCall)it);
    } else if (it != null) {
      return _doEvaluate(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
