package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.BinaryExpression
import com.yakindu.base.types.Expression
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.base.types.TypesFactory

class AddTimeTypeCastToScheduleTimeEventModification {
	
	@Inject extension ExpressionBuilder
	@Inject protected extension TypeBuilder
	protected extension TypesFactory factory = TypesFactory.eINSTANCE
	
	def void modify(ExecutionFlow it) {
		it.eAllContents.filter(ScheduleTimeEvent).forEach[modify]
	}
	
	def protected void modify(ScheduleTimeEvent it) {
		timeValue = timeValue.addTimeTypeCast
	}
	
	def dispatch protected Expression addTimeTypeCast(BinaryExpression it) {
		leftOperand = leftOperand.addTimeTypeCast
		return it
	}
	
	def dispatch protected Expression addTimeTypeCast(Expression it ) {
		it._cast(_typeSpecifier(timeType))
	}
	
	def protected create  tt : createType  timeType() {
		tt.name = "sc_time"
	}
	
}