/** 
 * Copyright (c) 2022 committers of itemis CREATE and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * Contributors:
 * committers of itemis CREATE - initial API and implementation
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.base.types.scoping.IPackageImport2URIMapper
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import java.util.List
import org.eclipse.xtext.EcoreUtil2

import static extension com.yakindu.sct.runtime.URIContentTypeHelper.*

class StatechartIncludeProvider implements IncludeProvider {

	@Inject IPackageImport2URIMapper includeMapper;
	@Inject protected extension FileNaming
	@Inject protected extension StatemachineTypes

	override getIncludes(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		collectImportedSubmachines
	}

	protected def submachineInclude(Statechart submachine) {
		if (submachine.hasOperations)
			'''#include "«module(submachine).client.h(submachine)»"'''
		else
			'''#include "«module(submachine).h(submachine)»"'''
	}

	protected def getPackageImports(ExecutionFlow flow) {
		val statechart = flow.sourceElement as Statechart
		val statechartImports = statechart.scopes.filter(ImportScope).map[imports].flatten
		return statechartImports.map [
			includeMapper.findPackageImport(statechart.eResource, it)
		].filter[isPresent].map[get]
	}
	
	def hasOperations(Statechart it) {
		!EcoreUtil2.eAllContents(it).filter(OperationDefinition).nullOrEmpty
	}
	
	def collectImportedSubmachines(ExecutionFlow it){
		val List<CharSequence> submachines = newArrayList
		val set = sourceElement.eResource.resourceSet
		packageImports.filter[fileURI.isStatechart].forEach [ import |
			val resource = set.getResource(import.fileURI, true)
			val submachine = resource.contents.filter(Statechart).head
			if (submachine instanceof Statechart) {
				submachines += submachine.submachineInclude
			}
			if(!declaredInternalStatemachineTypes.nullOrEmpty)
				submachines += '''#include "«statemachineModule.h»"'''
		]
		submachines
		
	}

}
