/**
 * Copyright (c) 2020-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author axel terfloth
 */
class Types implements IContentTemplate<ExecutionFlow> {

	@Inject protected extension FileNaming
	@Inject extension GenmodelEntries
	@Inject extension Literals
	@Inject extension CTypes

	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «typesModule.define»_H_
		#define «typesModule.define»_H_
		
		#ifdef __STDC_VERSION__
			#if __STDC_VERSION__ >= 199901L 
				#define HAS_C99_BOOLS
			#endif
		#else
			#ifdef __cplusplus
				#define HAS_C99_BOOLS
			#endif
		#endif
		
		#ifdef __cplusplus
		extern "C"
		{
		#endif 
		
		#include <stdint.h>
		#ifdef HAS_C99_BOOLS
		#include <stdbool.h>
		#endif
		
		#define sc_string		char*
		 
		#ifdef HAS_C99_BOOLS
		typedef bool			«sc_bool.name»;
		#else
		typedef uint8_t			«sc_bool.name»;
		#endif
		
		typedef int_fast16_t	«sc_short.name»;
		typedef uint_fast16_t	«sc_ushort.name»;
		typedef int32_t			«sc_integer.name»;
		typedef uint32_t		«sc_uinteger.name»;
		
		typedef «entry.getTimerServiceTimeType»       «sc_time.name»;
		
		typedef double			«sc_real.name»;
		
		typedef void*			«sc_eventid.name»;
		
		typedef intptr_t		«sc_intptr.name»;
		
		#ifdef __cplusplus
		}
		#endif
		
		#ifndef «NULL_LITERAL»
			#ifdef __cplusplus
				#if __cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1900)
			  		#define «NULL_LITERAL» nullptr
				#else
					#define «NULL_LITERAL» 0
				#endif
			#else
				#define «NULL_LITERAL» ((void *)0)
			#endif
		#endif
		
		#ifdef HAS_C99_BOOLS
		#define «TRUE_LITERAL» true
		#define «FALSE_LITERAL» false
		#else
		#define «TRUE_LITERAL» 1
		#define «FALSE_LITERAL» 0
		#endif
		
		#endif /* «typesModule.define»_H_ */
	'''
}
