/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.concepts

import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import com.google.inject.Inject

/**
 * This class defines the concept of a regular transition. 
 * 
 * @author terfloth@itemis.de
 */
class RegularTransition {
	
	@Inject extension CompletionTransition
	@Inject extension ExitTransition
	@Inject extension SgraphExtensions
		
	
	def boolean isRegularTransition(Transition it) {
		!exitTransition && !completionTransition	
	}
	
	def boolean hasRegularTransitions(RegularState it) {
		ownsRegularTransitions || (parentState !== null && parentState.hasRegularTransitions)
	}
	
	def boolean ownsRegularTransitions(RegularState it) {
		! it.outgoingTransitions.filter(r|r.isRegularTransition).toList.nullOrEmpty
	}
	
}