/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.c.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sctunit.generator.base.library.impl.BaseFeatureTypeLibraryProvider

class CSGenFeatureTypeLibraryProvider extends BaseFeatureTypeLibraryProvider {
	def junitWrapper() {
		createFeatureType => [
			name = "JUnitWrapper"
			optional = true
			parameters += createFeatureParameter => [
				name = "WrapToJUnit"
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def identifierSettings() {
		createFeatureType => [
			name = "IdentifierSettings"
			optional = true
			parameters += createFeatureParameter => [
				name = "moduleName"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "statemachinePrefix"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "maxIdentifierLength"
				optional = true
				parameterType = getType(INTEGER)
			]
			parameters += createFeatureParameter => [
				name = "separator"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "headerFilenameExtension"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "sourceFilenameExtension"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "testFilenameExtension"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	override functionInlining() {
		super.functionInlining => [
			optional = true
			parameters += createFeatureParameter => [
				name = "inlineReactions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEntryActions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitActions"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEnterSequences"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitSequences"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineChoices"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEnterRegion"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineExitRegion"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "inlineEntries"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]

	}

	def sgenModel() {
		createFeatureType => [
			name = "SGenModel"
			optional = true
			parameters += createFeatureParameter => [
				name = "GenerateSGen"
				parameterType = getType(BOOLEAN)
			]
		]
	}
	
	def generatorOptions() {
		createFeatureType => [
			name = "GeneratorOptions"
			optional = true
			parameters += createFeatureParameter => [
				name = "smartPointers"
				optional = true
				parameterType = getType(BOOLEAN)
			]			
		]
	}
	
	def generalFeatures() {
		createFeatureType => [
			name = "GeneralFeatures"
			optional = true
			parameters += createFeatureParameter => [
				name = "timerServiceTimeType"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "SCTUnit C Generator"
			types += junitWrapper()
			types += identifierSettings()
			types += sgenModel()
			types += generatorOptions()
			types += generalFeatures()
		]
	}
}
