/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.StatechartScope
import java.util.ArrayList
import java.util.List
import org.eclipse.emf.common.util.EList
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.types.resource.Statechart2TypeTransformation.NAMED_IFACE_CLASS
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * This extension defines names instance classes. 
 * 
 * @author axel terfloth - Initial contribution.
 */
//TODO: This is duplicate as we create the complex type for named ifaces in "Statechart2TypeTransformation"
@Singleton class NamedInterfaceClasses {

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension SExecExtensions
	@Inject protected extension INamingService
	@Inject protected extension StatemachineClass
	@Inject protected extension OriginTracing
	@Inject protected extension ITypeSystem
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension StatechartAnnotations

	def List<ComplexType> create new ArrayList<ComplexType> namedInterfaceClasses(ExecutionFlow flow) {

		flow.scopes.filter(InterfaceScope).filter[isNamedScope].forEach [ scope |
			val nic = scope.namedInterfaceClass
			flow.stateMachineClass.features += nic
			it.add(scope.namedInterfaceClass)
		]
	}

	def ComplexType namedInterfaceClass(Scope scope) {

		if (scope instanceof InterfaceScope) {
			if (scope.isNamedScope) {
				if (scope.stateMachineClass.features.exists[origin === scope || (origin !== null && (origin as EObject).origin === scope)])
					return scope.stateMachineClass.features.filter[origin === scope || (origin !== null && (origin as EObject).origin === scope)].head as ComplexType
				else
					return scope.createNamedInterfaceClass
			}
		}

		return null
	}

	def protected ComplexType create createComplexType createNamedInterfaceClass(InterfaceScope scope) {
		_annotate(NAMED_IFACE_CLASS)
		name = scope.name.toFirstUpper.asEscapedIdentifier.toFirstUpper
	}

	def dispatch boolean containsString(StatechartScope it) {
		members.containsString
	}

	def dispatch boolean containsString(ExecutionFlow it) {
		stateMachineClass.containsString || interfaceScopes.exists[containsString]
	}

	def dispatch boolean containsString(ComplexType it) {
		features.containsString
	}

	def dispatch boolean containsString(EList<EObject> it) {
		filter(Property).filter[!const].exists[p|p.type.isString]
	}

	def  ComplexType scopeClass(Scope it) {
		if(isNamedScope)
			namedInterfaceClass
		else stateMachineClass
	}
	
	def needsStatemachineReference(Scope scope) {
		(scope.statechart.isEventDriven && scope.hasIncomingEvents) || 
		scope.variableDefinitions.exists[needsShadowEventMapping] ||
		scope.outgoingEvents.exists[getLocalOutEvent() !== null]
	}

}
