/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.cpp

import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeUtils
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTDeclaration
import org.eclipse.cdt.core.dom.ast.IASTDeclarator
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTNode
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel

/**
 * @author rbeckmann
 * @author laszlo kovacs - extension for smart pointers
 *
 */
class CPPTypeUtils extends CTypeUtils {

	override dispatch boolean isVisible(IASTDeclaration decl) {
		val cls = findParentDeclSpecifier(decl) as IASTCompositeTypeSpecifier
		val template = decl.findParentTemplate
		var ICPPASTVisibilityLabel lastLabel = null

		for (IASTDeclaration member : cls.members) {
			if (member instanceof ICPPASTVisibilityLabel) {
				lastLabel = member
			} else if (member == decl || member == template) {
				if (lastLabel !== null) {
					return lastLabel.visibility == ICPPASTVisibilityLabel.v_public
				}
			}
		}
		// properties of structs etc. are visible per default
		return !cls.isClass
	}
	
	def ICPPASTTemplateDeclaration findParentTemplate(IASTNode it) {
		if(parent === null) {
			return null
		}
		if(parent instanceof ICPPASTTemplateDeclaration) {
			return parent as ICPPASTTemplateDeclaration
		}
		return parent.findParentTemplate
	}
	
	override isPointer(IASTDeclarator declarator) {
		return !declarator.getPointerOperators.isNullOrEmpty &&
			!(declarator.pointerOperators.head instanceof ICPPASTReferenceOperator)
	}
	
	override isSmartPointer(IASTNamedTypeSpecifier declarator) {
		return SMART_POINTER_TYPES.exists[t | declarator.name.toString.contains(t)] 
	}
	
	def isClass(IASTCompositeTypeSpecifier specifier) {
		ICPPASTCompositeTypeSpecifier.k_class == specifier.key
	}
	
	def dispatch getBuiltInType(ICPPASTNamedTypeSpecifier specifier) {
		if(specifier.name instanceof ICPPASTQualifiedName){
			var type = ts.getType(specifier.name.lastName.toString) 
			if(type !== null) 
				return type
		} 
		super.getBuiltInType(specifier)
	}
	
}