/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.types

import com.google.inject.Inject
import com.yakindu.sct.domain.c.runtime.resource.transform.TypeScope
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeNaming
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import org.eclipse.xtend.lib.annotations.Accessors

/**
 * @author rbeckmann
 *
 */
class TypeScopeHandler extends TypeHandler implements ITypeScopeOwner {
	@Inject protected extension CTypeNaming
	
	@Accessors(PUBLIC_SETTER) protected TypeScope typeScope
	
	override protected handle(IASTDeclSpecifier declSpecifier) {
		typeScope.get(declSpecifier.qualifiedName)
	}	
}