/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.python.extensions

import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Operation
import com.google.inject.Inject

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
class SCTUnitPythonExpressionExtensions extends PythonExpressionExtensions{
	
	@Inject extension PythonNavigationExtension
	@Inject extension NamingExtensions
	
	override dispatch referenceName(ElementReferenceExpression expression){
		if(expression.reference instanceof Parameter){
			(expression.reference as Parameter).name.toString
		}else{
			super._referenceName(expression)
		}
	}

	override dispatch CharSequence code(ElementReferenceExpression expression){
		//TODO: If event in named interface this doesnt work
		val ref = expression.reference
		if(ref.isLocal){
			return '''«IF !ref.globalVar»self.«ENDIF»«IF ref instanceof Operation»«expression.referenceName»(«FOR arg : expression.expressions SEPARATOR ","»«arg.code»«ENDFOR»)«ELSE»«expression.referenceName»«ENDIF»'''
		}
		else{
		'''statemachine.«expression.reference.getterName»()'''
		}		
	}
}