/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalNotExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.PostFixOperator
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.RelationalOperator
import com.yakindu.base.expressions.expressions.TypeCastExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Argument
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.generator.python.naming.PythonNamingService
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.BufferEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgraph.FinalState
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.ReturnExpression

class PythonExpressionsGenerator extends ExpressionsGenerator {

	@Inject extension Naming
	@Inject extension PythonNamingService
	@Inject extension SExecExtensions
	@Inject extension ITypeSystem
	@Inject extension ITypeSystemInferrer
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension StatechartUtil
	@Inject extension ExpressionExtensions
	@Inject extension PythonMultiStatemachineFunctionProvider
	@Inject extension GeneratorPredicate
	@Inject extension BufferEvent
	@Inject extension EventBuffer
	@Inject extension ShadowEventExtensions

	override dispatch CharSequence code(PostFixUnaryExpression it) {
		'''«operand.code» = «operand.code»«operator.unaryOperator»1'''
	}
	
	override dispatch CharSequence code(InitializationExpression it) {
		val originType = it.infer.type
		'''# Cannot generate InitializationExpression '«it»' for type '«originType»' as this feature is not yet supported.'''
	}

	def protected CharSequence unaryOperator(PostFixOperator operator) {
		switch operator {
			case PostFixOperator.DECREMENT: return '''-'''
			case PostFixOperator.INCREMENT: return '''+'''
			default: return '''#«operator» not implemented'''
		}
	}

	override dispatch CharSequence code(Argument it) {
		value.code
	}

	def dispatch code(OperationDefinition it) {
		'''self.«getContext»«scope.operationCallbackInstance».«identifier»'''
	}

	def dispatch code(Operation it) {
		'''«context»«getFunctionId»'''
	}

	def dispatch code(Method it) {
		'''self.«getContext»«methodShortName»'''
	}
	
	def dispatch String code(MetaCall it) {
		'''«owner.code»_«feature.identifier»'''
	}
	
	override dispatch code(AssignmentExpression it) {
		// TODO: Test and impl for multi sm with PostFixUnaryExpression
		if (expression instanceof PostFixUnaryExpression) {
			return '''
				«varRef.code» = «(expression as PostFixUnaryExpression).operand.code»
				«expression.code»
			'''
		}
		val property = varRef.featureOrReference
		if (property instanceof Property) {
			if (property.eContainer.isMultiSM) {
				return '''«varRef.code» = «assignCmdArgument(property)»'''
			}
			if (eContainer instanceof Expression) {
				return '''«property.getContext»«property.assign»(«assignCmdArgument(property)»)'''
			} else if (property.eContainer instanceof LocalVariableDefinition) {
				return '''«property.identifier» = «assignCmdArgument(property)»'''
			}
			return '''«property.getContext»«property.identifier» = «assignCmdArgument(property)»'''
		}
	}

	def assignCmdArgument(AssignmentExpression it, Property property) {
		if (!AssignmentOperator.ASSIGN.equals(operator)) {
			return '''«property.context»«property.identifier» «operator.modify» «expression.code»'''
		}
		return expression.code
	}

	def modify(AssignmentOperator it) '''«literal.replaceFirst("=", "")»'''

	def dispatch CharSequence code(LogicalAndExpression it) '''
	«leftOperand.code» «operator.name» «rightOperand.code»'''

	def dispatch CharSequence code(LogicalOrExpression it) '''
	«leftOperand.code» «operator.name» «rightOperand.code»'''

	def dispatch CharSequence code(LogicalNotExpression it) '''
	«operator.name» «operand.code»'''

	override dispatch String code(BoolLiteral expression) {
		expression.value.toString.toFirstUpper
	}

	override dispatch String code(NullLiteral expression) {
		'None'
	}
	
	override dispatch String code(ConditionalExpression expression) {
		expression.trueCase.code + " if " + expression.condition.code + " else " + expression.falseCase.code
	}

	def dispatch String code(LogicalRelationExpression it) {
		if (isSame(leftOperand.infer.type, getType(GenericTypeSystem.STRING))) {
			return logicalString
		}
		if (operator.isEqualOrNotEqual) {
			if (leftOperand.isBoolLiteral && !rightOperand.isBoolLiteral) {
				return rightOperand.code(leftOperand as PrimitiveValueExpression, operator)
			}
			if (!leftOperand.isBoolLiteral && rightOperand.isBoolLiteral) {
				return leftOperand.code(rightOperand as PrimitiveValueExpression, operator)
			}
			if (rightOperand.isNone) {
				return leftOperand.codeNone(operator)
			}
			if (leftOperand.isNone) {
				return leftOperand.codeNone(operator)
			}
		}
		leftOperand.code + " " + operator.literal + " " + rightOperand.code;
	}
	
	def dispatch isNone(Expression it) {
		false
	}
	
	def dispatch isNone(PrimitiveValueExpression it) {
		return value instanceof NullLiteral
	}
	
	def String codeNone(Expression it, RelationalOperator operator) {
		'''«it.code» is «IF operator.isNotEqualComparision»not «ENDIF»None'''
	}
	
	def code(Expression it, PrimitiveValueExpression primitiveValue, RelationalOperator operator){
		val value = primitiveValue.value as BoolLiteral
		if (operator.isEqualComparision) {
			return '''«IF !value.value»not «ENDIF»«code»'''
		}
		if (operator.isNotEqualComparision) {
			return '''«IF value.value»not «ENDIF»«code»'''
		}
	}
	
	def isEqualOrNotEqual(RelationalOperator it) {
		equalComparision || notEqualComparision
	}
	
	def isEqualComparision(RelationalOperator it) {
		value == RelationalOperator.EQUALS_VALUE
	}
	
	def isNotEqualComparision(RelationalOperator it) {
		value == RelationalOperator.NOT_EQUALS_VALUE 
	}
	
	def dispatch isBoolLiteral(Expression it) {
		return false
	}
	
	def dispatch isBoolLiteral(PrimitiveValueExpression it) {
		return value instanceof BoolLiteral
	}
	

	def String logicalString(LogicalRelationExpression it) {

		if (!(leftOperand instanceof PrimitiveValueExpression) && !(rightOperand instanceof PrimitiveValueExpression)) {
			return '''(«rightOperand.code» is None) if («leftOperand.code» is None) else («leftOperand.code» «operator.literal» «rightOperand.code»)'''
		} else {
			return '''«leftOperand.code» «operator.literal» «rightOperand.code»'''
		}
	}

	def dispatch String code(ActiveStateReferenceExpression it) {
		if ( value.isLeaf ) {
			val execState = flow.states.findFirst[ s | s.sourceElement === value]
			'''(self.«stateVector»[«execState.stateVector.offset»] == self.State.«value.stateName.asEscapedIdentifier»)'''
		}
		else "self.is_state_active(self.State." + value.stateName.asEscapedIdentifier + ")";
	}
	
	def dispatch String code(EventRaisingExpression it) {
		if (event.featureOrReference.eContainer instanceof ComplexType) {
			val fc = event
			if(fc instanceof FeatureCall) {
				return '''«fc.owner.code».«eventAccess»'''
			}
		}
		return '''«eventAccess»'''
	}

	protected def String eventAccess(EventRaisingExpression it) {
		val eventDefiniton = event.definition.event
		'''
		«IF eventDefiniton.isOutEvent»
			«IF useOutEventGetters»
				«event.definition.getContext»«event.featureOrReference.identifier» = True
				«IF value !== null»
					«event.definition.getContext»«event.featureOrReference.valueIdentifier» = «value.code»
				«ENDIF»
			«ENDIF»
			«IF useOutEventObservables»
				«event.definition.getContext»«eventDefiniton.asObservable».next(«IF value !== null»«value.code»«ENDIF»)
			«ENDIF»
			«IF eventDefiniton.getLocalOutEvent() !== null»
				«eventDefiniton.getLocalOutEvent().getContext»«eventDefiniton.getLocalOutEvent().raiseFunctionName»(«IF value !== null»«value.code»«ENDIF»)
			«ENDIF»
		«ELSE»
			«event.definition.getContext»«eventDefiniton.raiseFunctionName»(«IF value !== null»«value.code»«ENDIF»)
		«ENDIF»
		'''
	}

	def dispatch String code(EventValueReferenceExpression it) {
		val fc = value
		if (fc instanceof FeatureCall) {
			if (fc.feature.eContainer instanceof ComplexType) {
				return '''«fc.owner.code».«value.definition.getContext»«value.definition.event.valueIdentifier»'''
			}
		}
		value.definition.getContext + value.definition.event.valueIdentifier
	}

	override protected dispatch code(ElementReferenceExpression it) {
		it.code(reference)
	}

	def dispatch code(ArgumentExpression it, EObject target) {
		'''# Cannot generate ElementReferenceExpression '«it»' for target '«target»'.'''
	}

	def dispatch code(ArgumentExpression it, Declaration target) {
		'''«target.code»'''
	}

	def dispatch CharSequence code(FeatureCall it, Declaration target) {
		if (target.eContainer.multiSM && !target.isBufferEvent) {
			return '''«owner.code».«target.code»'''
		}
		'''«target.code»'''
	}
	
	def dispatch CharSequence code(FeatureCall it, Event target) {
		return '''«owner.code».«target.code»'''
	}
	
	def dispatch code(ArgumentExpression it, Operation target) {
		if (target.isStateMachineConcept) {
			return flow.stateMachineConceptCode(target)
		} else
		return '''«target.code»(«codeExpressions»)'''
	}

	override dispatch code(ElementReferenceExpression it, Operation target) {
		if (target.isStateMachineConcept) {
			return flow.stateMachineConceptCode(target)
		} else
		return '''«target.code»(«codeExpressions»)'''
	}

	protected def CharSequence codeExpressions(ArgumentExpression it) {
		'''«FOR exp : it.expressions SEPARATOR ", "»«exp.code»«ENDFOR»'''
	}

	def dispatch String access(Operation target, EObject it) {
		return '''# Cannot access operation '«target»' for object «it» .'''
	}

	def dispatch access(Operation target, VariableDefinition it) {
		return '''«code».«target.code»'''
	}

	def dispatch CharSequence code(FeatureCall it, Operation target) {
		if (target.eContainer instanceof ComplexType) {
			return '''«owner.code».«target.code»(«codeExpressions»)'''
		}
		'''«target.code»(«codeExpressions»)'''

	}

	def dispatch code(ArgumentExpression it, VariableDefinition target) {
		if (isPropertyContained) {
			return '''self.«target.identifier»'''
		}
		target.code
	}

	def dispatch CharSequence code(FeatureCall it, VariableDefinition target) {
		val container = target.eContainer
		if (container.multiSM) {
			return '''«owner.code».«target.code»'''
		}
		'''«target.code»'''
	}

	def dispatch code(ArgumentExpression it, Parameter target) {
		'''«target.code»'''
	}

	override dispatch code(FeatureCall it) {
		it.code(feature)
	}

	def dispatch code(FeatureCall it, Enumerator target) {
		if (target.eContainer.isOriginStatechart) {
			return '''«owner.code».«target.stateName»'''
		}
		'''«target.code»'''
	}

	def dispatch code(Enumerator it) {
		'''«name»'''
	}

	def dispatch CharSequence code(FeatureCall it, EnumerationType target) {
		'''«target.enumAccess».«stateEnumName»'''
	}

	def dispatch code(ArgumentExpression it, Property target) {
		'''«target.getStaticContext + target.identifier»'''
	}

	def dispatch CharSequence code(FeatureCall it, Property target) {
		val ct = target.eContainer
		if (ct instanceof ComplexType) {
			if(ct.isEventBuffer) {
				return '''«owner.code».«target.identifier»'''
			} else {
				return '''«owner.code»«target.getStaticContext»'''
			}
		}
		'''«target.getStaticContext»«target.identifier»'''

	}

	def dispatch String code(Declaration it) {
		if (eContainer.multiSM) {
			return '''«getContext»«identifier»'''
		}
		"self." + getContext + identifier
	}
	
	def dispatch String code(Event it) {
		if(isBufferEvent) {
			return '''«identifier»'''
		}
		if (eContainer.multiSM) {
			return '''«getContext»«identifier»'''
		}
		getContext + identifier
	}

	def dispatch String code(Property it) {
		getContext + identifier
	}

	def dispatch String code(TimeEvent it) {
		"self."+ timeEvents + "[" + flow.timeEvents.indexOf(it) + "]"
	}

	override dispatch String code(TypeCastExpression it) {
		'''(«type.getTargetLanguageName»(«operand.code»))'''
	}

	def dispatch code(Parameter it) {
		name
	}
	
	
	override dispatch CharSequence code(ReturnExpression it) '''
		return«IF expression !== null» «expression.code»«ENDIF»
	'''
	
	
	override dispatch CharSequence code(BlockExpression it) 
	'''«FOR e : expressions»«e.code»«ENDFOR»'''
	
	
	override CharSequence statement(Expression it) {
		code
	}


	def dispatch String getContext(Property it) {
		if (type.isEventBuffer) {
			return "self."
		}
		if (eContainer instanceof ExecutionFlow) {
			return "self."
		}
		if (isInNamedInterface) {
			return "self." + interfaceScope.interfaceVariableName + "."
		}
		val scope = scope
		if (scope !== null) {
			if (eContainer.multiSM) {
				if (scope instanceof InterfaceScope) {
					if (!scope.name.nullOrEmpty) {
						return scope.interfaceVariableName + "."
					}
				}
				return ""
			}
			return "self."
		}

		return ""
	}

	def dispatch String getStaticContext(Property it) {
		if (it.const) {
			if (isInNamedInterface) {
				return "self." + interfaceScope.interfaceVariableName + "."
			} else {
				return "self."
			}
		}
		return getContext()
	}
	
	def dispatch String getContext(Event it) {
		if (isInNamedInterface) {
			return "self." + interfaceScope.interfaceVariableName + "."
		}
		val scope = scope
		if (scope !== null) {
			if (eContainer.multiSM) {
				if (scope instanceof InterfaceScope) {
					if (!scope.name.nullOrEmpty) {
						return scope.interfaceVariableName + "."
					}
				}
				return ""
			}
			return "self."
		}

		return ""
	}
	
	def getShadowEventContext(Event it) {
		val scope = scope
		if (scope instanceof InterfaceScope) {
			if (!scope.name.nullOrEmpty)
				return '''«scope.interfaceVariableName».'''
		}
		""		
	}

	def dispatch String getContext(Declaration it) {
		val scope = scope
		if (scope instanceof InterfaceScope) {
			if (!scope.name.nullOrEmpty)
				return '''«scope.interfaceVariableName».'''
		}
		""
	}

	def dispatch String getContext(EObject it) {
		return "# ERROR: No context for " + it
	}

	def dispatch String getStaticContext(EObject it) {
		return "# ERROR: No context for " + it
	}

	def boolean isPropertyContained(Expression it) {
		if (eContainer instanceof Property) {
			return true
		} else if (eContainer instanceof Expression) {
			return isPropertyContained(eContainer as Expression)
		}
		return false // default
	}
	
	def protected dispatch boolean isLeaf(State s) {
		s.isLeaf
	}
	def protected dispatch boolean isLeaf(FinalState fs) {
		true
	}
	
}
