/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python.submodules

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.python.PythonExpressionsGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * @author Robin Herrmann
 */
class EventCode implements com.yakindu.sct.generator.core.submodules.lifecycle.EventCode {
	@Inject protected extension PythonExpressionsGenerator
	@Inject protected extension EventProcessing
	@Inject protected extension SExecExtensions
	@Inject protected extension ExpressionBuilder

	override eventClearCode(ExecutionFlow flow, Expression event) '''«event.code» = False'''

	override eventMoveCode(ExecutionFlow flow, Expression source, Expression target) '''
		«target.code» = «source.code»
		«IF source.event.hasValue»«target._meta(target.event.valueFeature).code» = «source._meta(source.event.valueFeature).code»«ENDIF»
		«source.code» = False
	'''

	override eventNextCode(ExecutionFlow flow) {
		throw new UnsupportedOperationException(
			"Something went wrong - generating 'eventNext' not supported for cycle based statecharts.")
	}
	
	override getNextEventCode(ExecutionFlow flow) {
		throw new UnsupportedOperationException("Something went wrong - generating 'eventNext' not supported for cycle based statecharts.")
	}

}
