
window.addEventListener("load", (e) => {

    var valueElements = document.querySelectorAll('.lightbulb.y-value-observer');
    valueElements.forEach( ve => {

        ve.onvaluechange = (value) => {
            var checkedValue = value;
            if (checkedValue < 0) checkedValue = 0;
            var size = '' + (20 + (6 * checkedValue)) + 'px';
            ve.style.height = size;
            ve.style.width = size;

            if (checkedValue == 0) {
                ve.classList.remove('bulb-on');
            } else if (!ve.classList.contains('bulb-on')) {
                ve.classList.add('bulb-on');
            }
        }
     }); 

     

     var plotElements = document.querySelectorAll('.plot.y-value-observer');
     plotElements.forEach( ve => {

        ve.plot = {
            startTime : 0,
            data: {
                x: [-1, 0],
                y: [0, 0],
                mode: 'lines+markers',
                type: 'scatter',
                line: {shape: 'hv'}
            },
            layout: {
                margin: { t: 5, b: 30, r: 5, l: 30 },
                showlegend: false       
            },
            options: {
                displayModeBar: false,
                responsive: true
            }
        }

        ve.plot.startTime = Date.now();
        Plotly.newPlot( ve, [ve.plot.data],ve.plot.layout, ve.plot.options );
        
         ve.onvaluechange = (value) => {
             console.log("new plot value " + value);
             var plot = ve.plot;
             var time = ((Date.now() - plot.startTime) / 1000);
             plot.data.x.push(time);
             plot.data.y.push(value);
             if (plot.data.x.length > 50) plot.data.x.shift();
             if (plot.data.y.length > 50) plot.data.y.shift();

             Plotly.newPlot( ve, [plot.data], plot.layout, plot.options );
         }
      }); 
});
